/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.config.AzureConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.EurekaConfig;
import com.hazelcast.config.GcpConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ClientNetworkConfig {
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int CONNECTION_ATTEMPT_PERIOD = 3000;
    private final List<String> addressList = new ArrayList<String>(10);
    private boolean smartRouting = true;
    private boolean redoOperation;
    private int connectionTimeout = 5000;
    private int connectionAttemptLimit = -1;
    private int connectionAttemptPeriod = 3000;
    private SocketInterceptorConfig socketInterceptorConfig;
    private SocketOptions socketOptions = new SocketOptions();
    private SSLConfig sslConfig;
    private ClientAwsConfig awsConfig = new ClientAwsConfig();
    private GcpConfig gcpConfig = new GcpConfig();
    private AzureConfig azureConfig = new AzureConfig();
    private KubernetesConfig kubernetesConfig = new KubernetesConfig();
    private EurekaConfig eurekaConfig = new EurekaConfig();
    private ClientCloudConfig cloudConfig = new ClientCloudConfig();
    private DiscoveryConfig discoveryConfig;
    private Collection<String> outboundPortDefinitions;
    private Collection<Integer> outboundPorts;
    private ClientIcmpPingConfig clientIcmpPingConfig = new ClientIcmpPingConfig();

    public DiscoveryConfig getDiscoveryConfig() {
        if (this.discoveryConfig == null) {
            this.discoveryConfig = new DiscoveryConfig();
        }
        return this.discoveryConfig;
    }

    public void setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = (DiscoveryConfig)Preconditions.isNotNull((Object)discoveryConfig, (String)"discoveryConfig");
    }

    public boolean isSmartRouting() {
        return this.smartRouting;
    }

    public ClientNetworkConfig setSmartRouting(boolean smartRouting) {
        this.smartRouting = smartRouting;
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public ClientNetworkConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = socketInterceptorConfig;
        return this;
    }

    public int getConnectionAttemptPeriod() {
        return this.connectionAttemptPeriod;
    }

    public ClientNetworkConfig setConnectionAttemptPeriod(int connectionAttemptPeriod) {
        if (connectionAttemptPeriod < 0) {
            throw new IllegalArgumentException("connectionAttemptPeriod cannot be negative");
        }
        this.connectionAttemptPeriod = connectionAttemptPeriod;
        return this;
    }

    public int getConnectionAttemptLimit() {
        return this.connectionAttemptLimit;
    }

    public ClientNetworkConfig setConnectionAttemptLimit(int connectionAttemptLimit) {
        if (connectionAttemptLimit < 0) {
            throw new IllegalArgumentException("connectionAttemptLimit cannot be negative");
        }
        this.connectionAttemptLimit = connectionAttemptLimit;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientNetworkConfig setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException("connectionTimeout cannot be negative");
        }
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public ClientNetworkConfig addAddress(String ... addresses) {
        Preconditions.isNotNull((Object)addresses, (String)"addresses");
        for (String address : addresses) {
            Preconditions.isNotNull((Object)address, (String)"address");
            Preconditions.checkHasText((String)address.trim(), (String)"member must contain text");
        }
        Collections.addAll(this.addressList, addresses);
        return this;
    }

    public ClientNetworkConfig setAddresses(List<String> addresses) {
        this.addressList.clear();
        this.addressList.addAll(addresses);
        return this;
    }

    public List<String> getAddresses() {
        return this.addressList;
    }

    public boolean isRedoOperation() {
        return this.redoOperation;
    }

    public ClientNetworkConfig setRedoOperation(boolean redoOperation) {
        this.redoOperation = redoOperation;
        return this;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ClientNetworkConfig setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
        return this;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public ClientNetworkConfig setSSLConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public ClientNetworkConfig setAwsConfig(ClientAwsConfig clientAwsConfig) {
        this.awsConfig = clientAwsConfig;
        return this;
    }

    public ClientAwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public ClientNetworkConfig setGcpConfig(GcpConfig gcpConfig) {
        this.gcpConfig = gcpConfig;
        return this;
    }

    public GcpConfig getGcpConfig() {
        return this.gcpConfig;
    }

    public ClientNetworkConfig setAzureConfig(AzureConfig azureConfig) {
        this.azureConfig = azureConfig;
        return this;
    }

    public AzureConfig getAzureConfig() {
        return this.azureConfig;
    }

    public ClientNetworkConfig setKubernetesConfig(KubernetesConfig kubernetesConfig) {
        this.kubernetesConfig = kubernetesConfig;
        return this;
    }

    public KubernetesConfig getKubernetesConfig() {
        return this.kubernetesConfig;
    }

    public ClientNetworkConfig setEurekaConfig(EurekaConfig eurekaConfig) {
        this.eurekaConfig = eurekaConfig;
        return this;
    }

    public EurekaConfig getEurekaConfig() {
        return this.eurekaConfig;
    }

    public ClientCloudConfig getCloudConfig() {
        return this.cloudConfig;
    }

    public void setCloudConfig(ClientCloudConfig cloudConfig) {
        this.cloudConfig = cloudConfig;
    }

    public Collection<String> getOutboundPortDefinitions() {
        return this.outboundPortDefinitions;
    }

    public Collection<Integer> getOutboundPorts() {
        return this.outboundPorts;
    }

    public ClientNetworkConfig setOutboundPortDefinitions(Collection<String> outboundPortDefinitions) {
        this.outboundPortDefinitions = outboundPortDefinitions;
        return this;
    }

    public ClientNetworkConfig setOutboundPorts(Collection<Integer> outboundPorts) {
        this.outboundPorts = outboundPorts;
        return this;
    }

    public ClientNetworkConfig addOutboundPort(int port) {
        if (this.outboundPorts == null) {
            this.outboundPorts = new HashSet<Integer>();
        }
        this.outboundPorts.add(port);
        return this;
    }

    public ClientNetworkConfig addOutboundPortDefinition(String portDef) {
        if (this.outboundPortDefinitions == null) {
            this.outboundPortDefinitions = new HashSet<String>();
        }
        this.outboundPortDefinitions.add(portDef);
        return this;
    }

    public ClientIcmpPingConfig getClientIcmpPingConfig() {
        return this.clientIcmpPingConfig;
    }

    public ClientNetworkConfig setClientIcmpPingConfig(ClientIcmpPingConfig clientIcmpPingConfig) {
        this.clientIcmpPingConfig = clientIcmpPingConfig;
        return this;
    }
}

