/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.cache.impl.ClientCacheProxyFactory;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddDistributedObjectListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientCreateProxiesCodec;
import com.hazelcast.client.impl.protocol.codec.ClientCreateProxyCodec;
import com.hazelcast.client.impl.protocol.codec.ClientRemoveDistributedObjectListenerCodec;
import com.hazelcast.client.proxy.ClientAtomicLongProxy;
import com.hazelcast.client.proxy.ClientAtomicReferenceProxy;
import com.hazelcast.client.proxy.ClientCardinalityEstimatorProxy;
import com.hazelcast.client.proxy.ClientCountDownLatchProxy;
import com.hazelcast.client.proxy.ClientDurableExecutorServiceProxy;
import com.hazelcast.client.proxy.ClientExecutorServiceProxy;
import com.hazelcast.client.proxy.ClientFlakeIdGeneratorProxy;
import com.hazelcast.client.proxy.ClientIdGeneratorProxy;
import com.hazelcast.client.proxy.ClientListProxy;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.proxy.ClientMapReduceProxy;
import com.hazelcast.client.proxy.ClientMultiMapProxy;
import com.hazelcast.client.proxy.ClientPNCounterProxy;
import com.hazelcast.client.proxy.ClientQueueProxy;
import com.hazelcast.client.proxy.ClientReliableTopicProxy;
import com.hazelcast.client.proxy.ClientReplicatedMapProxy;
import com.hazelcast.client.proxy.ClientRingbufferProxy;
import com.hazelcast.client.proxy.ClientScheduledExecutorProxy;
import com.hazelcast.client.proxy.ClientSemaphoreProxy;
import com.hazelcast.client.proxy.ClientSetProxy;
import com.hazelcast.client.proxy.ClientTopicProxy;
import com.hazelcast.client.proxy.txn.xa.XAResourceProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyDescriptor;
import com.hazelcast.client.spi.ClientProxyDescriptorProvider;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientProxyFactoryWithContext;
import com.hazelcast.client.spi.impl.ClientServiceNotFoundException;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.LazyDistributedObjectEvent;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.Member;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.DistributedObjectNamespace;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ServiceLoader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public final class ProxyManager {
    private static final String PROVIDER_ID = ClientProxyDescriptorProvider.class.getCanonicalName();
    private static final Class[] LEGACY_CONSTRUCTOR_ARGUMENT_TYPES = new Class[]{String.class, String.class};
    private static final Class[] CONSTRUCTOR_ARGUMENT_TYPES = new Class[]{String.class, String.class, ClientContext.class};
    private final ConcurrentMap<String, ClientProxyFactory> proxyFactories = new ConcurrentHashMap<String, ClientProxyFactory>();
    private final ConcurrentMap<ObjectNamespace, ClientProxyFuture> proxies = new ConcurrentHashMap<ObjectNamespace, ClientProxyFuture>();
    private final ListenerMessageCodec distributedObjectListenerCodec = new ListenerMessageCodec(){

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return ClientAddDistributedObjectListenerCodec.encodeRequest((boolean)localOnly);
        }

        @Override
        public String decodeAddResponse(ClientMessage clientMessage) {
            return ClientAddDistributedObjectListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
        }

        @Override
        public ClientMessage encodeRemoveRequest(String realRegistrationId) {
            return ClientRemoveDistributedObjectListenerCodec.encodeRequest((String)realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return ClientRemoveDistributedObjectListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private final HazelcastClientInstanceImpl client;
    private ClientContext context;
    private long invocationRetryPauseMillis;
    private long invocationTimeoutMillis;

    public ProxyManager(HazelcastClientInstanceImpl client) {
        this.client = client;
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                if (!(listenerConfig.getImplementation() instanceof DistributedObjectListener)) continue;
                this.addDistributedObjectListener((DistributedObjectListener)listenerConfig.getImplementation());
            }
        }
    }

    public void init(ClientConfig config, ClientContext clientContext) {
        this.context = clientContext;
        this.register("hz:impl:mapService", this.createServiceProxyFactory(MapService.class));
        if (JCacheDetector.isJCacheAvailable((ClassLoader)config.getClassLoader())) {
            this.register("hz:impl:cacheService", new ClientCacheProxyFactory(this.client));
        }
        this.register("hz:impl:queueService", ClientQueueProxy.class);
        this.register("hz:impl:multiMapService", ClientMultiMapProxy.class);
        this.register("hz:impl:listService", ClientListProxy.class);
        this.register("hz:impl:setService", ClientSetProxy.class);
        this.register("hz:impl:semaphoreService", ClientSemaphoreProxy.class);
        this.register("hz:impl:topicService", ClientTopicProxy.class);
        this.register("hz:impl:atomicLongService", ClientAtomicLongProxy.class);
        this.register("hz:impl:atomicReferenceService", ClientAtomicReferenceProxy.class);
        this.register("hz:impl:executorService", ClientExecutorServiceProxy.class);
        this.register("hz:impl:durableExecutorService", ClientDurableExecutorServiceProxy.class);
        this.register("hz:impl:lockService", ClientLockProxy.class);
        this.register("hz:impl:countDownLatchService", ClientCountDownLatchProxy.class);
        this.register("hz:impl:mapReduceService", ClientMapReduceProxy.class);
        this.register("hz:impl:replicatedMapService", ClientReplicatedMapProxy.class);
        this.register("hz:impl:xaService", XAResourceProxy.class);
        this.register("hz:impl:ringbufferService", ClientRingbufferProxy.class);
        this.register("hz:impl:reliableTopicService", new ClientProxyFactoryWithContext(){

            @Override
            public ClientProxy create(String id, ClientContext context) {
                return new ClientReliableTopicProxy(id, context, ProxyManager.this.client);
            }
        });
        this.register("hz:impl:idGeneratorService", new ClientProxyFactoryWithContext(){

            @Override
            public ClientProxy create(String id, ClientContext context) {
                IAtomicLong atomicLong = ProxyManager.this.client.getAtomicLong("hz:atomic:idGenerator:" + id);
                return new ClientIdGeneratorProxy("hz:impl:idGeneratorService", id, context, atomicLong);
            }
        });
        this.register("hz:impl:flakeIdGeneratorService", ClientFlakeIdGeneratorProxy.class);
        this.register("hz:impl:cardinalityEstimatorService", ClientCardinalityEstimatorProxy.class);
        this.register("hz:impl:scheduledExecutorService", ClientScheduledExecutorProxy.class);
        this.register("hz:impl:PNCounterService", ClientPNCounterProxy.class);
        ClassLoader classLoader = config.getClassLoader();
        for (ProxyFactoryConfig proxyFactoryConfig : config.getProxyFactoryConfigs()) {
            try {
                ClientProxyFactory clientProxyFactory = proxyFactoryConfig.getFactoryImpl();
                if (clientProxyFactory == null) {
                    String className = proxyFactoryConfig.getClassName();
                    clientProxyFactory = (ClientProxyFactory)ClassLoaderUtil.newInstance((ClassLoader)classLoader, (String)className);
                }
                this.register(proxyFactoryConfig.getService(), clientProxyFactory);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        this.readProxyDescriptors();
        AbstractClientInvocationService invocationService = (AbstractClientInvocationService)this.client.getInvocationService();
        this.invocationTimeoutMillis = invocationService.getInvocationTimeoutMillis();
        this.invocationRetryPauseMillis = invocationService.getInvocationRetryPauseMillis();
    }

    private void readProxyDescriptors() {
        try {
            ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
            Iterator iter = ServiceLoader.classIterator(ClientProxyDescriptorProvider.class, (String)PROVIDER_ID, (ClassLoader)classLoader);
            while (iter.hasNext()) {
                ClientProxyDescriptor[] services;
                Class clazz = (Class)iter.next();
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                ClientProxyDescriptorProvider provider = (ClientProxyDescriptorProvider)constructor.newInstance(new Object[0]);
                for (ClientProxyDescriptor serviceDescriptor : services = provider.createClientProxyDescriptors()) {
                    this.register(serviceDescriptor.getServiceName(), serviceDescriptor.getClientProxyClass());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private <T> ClientProxyFactory createServiceProxyFactory(Class<T> service) {
        ClientExtension clientExtension = this.client.getClientExtension();
        return clientExtension.createServiceProxyFactory(service);
    }

    public ClientContext getContext() {
        return this.context;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.client;
    }

    public ClientProxyFactory getClientProxyFactory(String serviceName) {
        return (ClientProxyFactory)this.proxyFactories.get(serviceName);
    }

    public void register(String serviceName, ClientProxyFactory factory) {
        if (this.proxyFactories.putIfAbsent(serviceName, factory) != null) {
            throw new IllegalArgumentException("Factory for service " + serviceName + " is already registered!");
        }
    }

    public void register(final String serviceName, final Class<? extends ClientProxy> proxyType) {
        try {
            this.register(serviceName, new ClientProxyFactoryWithContext(){

                @Override
                public ClientProxy create(String id, ClientContext context) {
                    return (ClientProxy)ProxyManager.this.instantiateClientProxy(proxyType, serviceName, context, id);
                }
            });
        }
        catch (Exception e) {
            throw new HazelcastException("Factory for service " + serviceName + " could not be created for " + proxyType, (Throwable)e);
        }
    }

    public ClientProxy getOrCreateProxy(String service, String id) {
        DistributedObjectNamespace ns = new DistributedObjectNamespace(service, id);
        ClientProxyFuture proxyFuture = (ClientProxyFuture)this.proxies.get(ns);
        if (proxyFuture != null) {
            return proxyFuture.get();
        }
        ClientProxyFactory factory = (ClientProxyFactory)this.proxyFactories.get(service);
        if (factory == null) {
            throw new ClientServiceNotFoundException("No factory registered for service: " + service);
        }
        proxyFuture = new ClientProxyFuture();
        ClientProxyFuture current = this.proxies.putIfAbsent((ObjectNamespace)ns, proxyFuture);
        if (current != null) {
            return current.get();
        }
        try {
            ClientProxy clientProxy = this.createClientProxy(id, factory);
            this.initializeWithRetry(clientProxy);
            proxyFuture.set(clientProxy);
            return clientProxy;
        }
        catch (Throwable e) {
            this.proxies.remove(ns);
            proxyFuture.set(e);
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyProxy(ClientProxy proxy) {
        block7: {
            DistributedObjectNamespace objectNamespace = new DistributedObjectNamespace(proxy.getServiceName(), proxy.getDistributedObjectName());
            ClientProxyFuture registeredProxyFuture = (ClientProxyFuture)this.proxies.remove(objectNamespace);
            ClientProxy registeredProxy = registeredProxyFuture == null ? null : registeredProxyFuture.get();
            try {
                if (registeredProxy == null) break block7;
                try {
                    registeredProxy.destroyLocally();
                }
                finally {
                    registeredProxy.destroyRemotely();
                }
            }
            finally {
                if (proxy != registeredProxy) {
                    proxy.destroyLocally();
                }
            }
        }
    }

    public void destroyProxyLocally(String service, String id) {
        DistributedObjectNamespace objectNamespace = new DistributedObjectNamespace(service, id);
        ClientProxyFuture clientProxyFuture = (ClientProxyFuture)this.proxies.remove(objectNamespace);
        if (clientProxyFuture != null) {
            ClientProxy clientProxy = clientProxyFuture.get();
            clientProxy.destroyLocally();
        }
    }

    private ClientProxy createClientProxy(String id, ClientProxyFactory factory) {
        if (factory instanceof ClientProxyFactoryWithContext) {
            return ((ClientProxyFactoryWithContext)factory).create(id, this.context);
        }
        return factory.create(id).setContext(this.context);
    }

    private void initializeWithRetry(ClientProxy clientProxy) throws Exception {
        long startMillis = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMillis + this.invocationTimeoutMillis) {
            try {
                this.initialize(clientProxy);
                return;
            }
            catch (Exception e) {
                boolean retryable = this.isRetryable(e);
                if (!retryable && e instanceof ExecutionException) {
                    retryable = this.isRetryable(e.getCause());
                }
                if (retryable) {
                    this.sleepForProxyInitRetry();
                    continue;
                }
                throw e;
            }
        }
        long elapsedTime = System.currentTimeMillis() - startMillis;
        throw new OperationTimeoutException("Initializing  " + clientProxy.getServiceName() + ":" + clientProxy.getName() + " is timed out after " + elapsedTime + " ms. Configured invocation timeout is " + this.invocationTimeoutMillis + " ms");
    }

    private boolean isRetryable(Throwable t) {
        return ClientInvocation.isRetrySafeException(t);
    }

    private void sleepForProxyInitRetry() {
        try {
            Thread.sleep(this.invocationRetryPauseMillis);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    private void initialize(ClientProxy clientProxy) throws Exception {
        Address initializationTarget = this.findNextAddressToSendCreateRequest();
        if (initializationTarget == null) {
            throw new IOException("Not able to find a member to create proxy on!");
        }
        ClientMessage clientMessage = ClientCreateProxyCodec.encodeRequest((String)clientProxy.getDistributedObjectName(), (String)clientProxy.getServiceName(), (Address)initializationTarget);
        new ClientInvocation(this.client, clientMessage, clientProxy.getServiceName(), initializationTarget).invoke().get();
        clientProxy.onInitialize();
    }

    public Address findNextAddressToSendCreateRequest() {
        int clusterSize = this.client.getClientClusterService().getSize();
        if (clusterSize == 0) {
            throw new HazelcastClientOfflineException("Client connecting to cluster");
        }
        Member liteMember = null;
        LoadBalancer loadBalancer = this.client.getLoadBalancer();
        for (int i = 0; i < clusterSize; ++i) {
            Member member = loadBalancer.next();
            if (member != null && !member.isLiteMember()) {
                return member.getAddress();
            }
            if (liteMember != null) continue;
            liteMember = member;
        }
        return liteMember != null ? liteMember.getAddress() : null;
    }

    public Collection<? extends DistributedObject> getDistributedObjects() {
        LinkedList<ClientProxy> objects = new LinkedList<ClientProxy>();
        for (ClientProxyFuture future : this.proxies.values()) {
            objects.add(future.get());
        }
        return objects;
    }

    public void destroy() {
        for (ClientProxyFuture future : this.proxies.values()) {
            future.get().onShutdown();
        }
        this.proxies.clear();
    }

    public String addDistributedObjectListener(DistributedObjectListener listener) {
        DistributedObjectEventHandler eventHandler = new DistributedObjectEventHandler(listener, this);
        return this.client.getListenerService().registerListener(this.distributedObjectListenerCodec, eventHandler);
    }

    public void createDistributedObjectsOnCluster(Connection ownerConnection) {
        LinkedList<AbstractMap.SimpleEntry<String, String>> proxyEntries = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
        for (ObjectNamespace objectNamespace : this.proxies.keySet()) {
            String name = objectNamespace.getObjectName();
            String serviceName = objectNamespace.getServiceName();
            proxyEntries.add(new AbstractMap.SimpleEntry<String, String>(name, serviceName));
        }
        if (proxyEntries.isEmpty()) {
            return;
        }
        ClientMessage clientMessage = ClientCreateProxiesCodec.encodeRequest(proxyEntries);
        new ClientInvocation(this.client, clientMessage, null, ownerConnection).invokeUrgent();
    }

    public boolean removeDistributedObjectListener(String id) {
        return this.client.getListenerService().deregisterListener(id);
    }

    private <T> T instantiateClientProxy(Class<T> proxyType, String serviceName, ClientContext context, String id) {
        try {
            try {
                Constructor<T> constructor = proxyType.getConstructor(CONSTRUCTOR_ARGUMENT_TYPES);
                return constructor.newInstance(serviceName, id, context);
            }
            catch (NoSuchMethodException e) {
                Constructor<T> constructor = proxyType.getConstructor(LEGACY_CONSTRUCTOR_ARGUMENT_TYPES);
                return constructor.newInstance(serviceName, id);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static class ClientProxyFuture {
        volatile Object proxy;

        private ClientProxyFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClientProxy get() {
            if (this.proxy == null) {
                boolean interrupted = false;
                ClientProxyFuture clientProxyFuture = this;
                synchronized (clientProxyFuture) {
                    while (this.proxy == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.proxy instanceof Throwable) {
                throw ExceptionUtil.rethrow((Throwable)((Throwable)this.proxy));
            }
            return (ClientProxy)this.proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(Object o) {
            if (o == null) {
                throw new IllegalArgumentException();
            }
            ClientProxyFuture clientProxyFuture = this;
            synchronized (clientProxyFuture) {
                this.proxy = o;
                this.notifyAll();
            }
        }
    }

    private final class DistributedObjectEventHandler
    extends ClientAddDistributedObjectListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final DistributedObjectListener listener;
        private ProxyManager proxyManager;

        private DistributedObjectEventHandler(DistributedObjectListener listener, ProxyManager proxyManager2) {
            this.listener = listener;
            this.proxyManager = proxyManager2;
        }

        public void handleDistributedObjectEventV10(String name, String serviceName, String eventTypeName) {
            DistributedObjectNamespace ns = new DistributedObjectNamespace(serviceName, name);
            ClientProxyFuture future = (ClientProxyFuture)ProxyManager.this.proxies.get(ns);
            ClientProxy proxy = future == null ? null : future.get();
            DistributedObjectEvent.EventType eventType = DistributedObjectEvent.EventType.valueOf((String)eventTypeName);
            LazyDistributedObjectEvent event = new LazyDistributedObjectEvent(eventType, serviceName, name, proxy, this.proxyManager);
            if (DistributedObjectEvent.EventType.CREATED.equals((Object)eventType)) {
                this.listener.distributedObjectCreated((DistributedObjectEvent)event);
            } else if (DistributedObjectEvent.EventType.DESTROYED.equals((Object)eventType)) {
                this.listener.distributedObjectDestroyed((DistributedObjectEvent)event);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

