/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.ClientConnectionStrategy;
import com.hazelcast.client.connection.nio.AuthenticationFuture;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClusterConnector;
import com.hazelcast.client.connection.nio.DefaultClientConnectionStrategy;
import com.hazelcast.client.connection.nio.HeartbeatManager;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.nio.NioNetworking;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.util.ExceptionUtil;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final int DEFAULT_SSL_THREAD_COUNT = 3;
    protected final AtomicInteger connectionIdGen = new AtomicInteger();
    protected volatile boolean alive;
    private final ILogger logger;
    private final int connectionTimeoutMillis;
    private final HazelcastClientInstanceImpl client;
    private final SocketInterceptor socketInterceptor;
    private final ClientExecutionServiceImpl executionService;
    private final AddressTranslator addressTranslator;
    private final ConcurrentMap<Address, ClientConnection> activeConnections = new ConcurrentHashMap<Address, ClientConnection>();
    private final ConcurrentMap<Address, AuthenticationFuture> connectionsInProgress = new ConcurrentHashMap<Address, AuthenticationFuture>();
    private final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final boolean allowInvokeWhenDisconnected;
    private final Credentials credentials;
    private final NioNetworking networking;
    private final HeartbeatManager heartbeat;
    private final ClusterConnector clusterConnector;
    private final long authenticationTimeout;
    private volatile ClientPrincipal principal;
    private final ClientConnectionStrategy connectionStrategy;
    private final LinkedList<Integer> outboundPorts = new LinkedList();
    private final int outboundPortCount;

    public ClientConnectionManagerImpl(HazelcastClientInstanceImpl client, AddressTranslator addressTranslator, Collection<AddressProvider> addressProviders) {
        this.allowInvokeWhenDisconnected = client.getProperties().getBoolean(ClientProperty.ALLOW_INVOCATIONS_WHEN_DISCONNECTED);
        this.client = client;
        this.addressTranslator = addressTranslator;
        this.logger = client.getLoggingService().getLogger(ClientConnectionManager.class);
        ClientNetworkConfig networkConfig = client.getClientConfig().getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        this.connectionTimeoutMillis = connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.networking = this.initNetworking(client);
        this.socketInterceptor = this.initSocketInterceptor(networkConfig.getSocketInterceptorConfig());
        this.credentials = client.getCredentials();
        this.connectionStrategy = this.initializeStrategy(client);
        this.outboundPorts.addAll(this.getOutboundPorts(networkConfig));
        this.outboundPortCount = this.outboundPorts.size();
        this.heartbeat = new HeartbeatManager(this, client);
        this.authenticationTimeout = this.heartbeat.getHeartbeatTimeout();
        this.clusterConnector = new ClusterConnector(client, this, this.connectionStrategy, addressProviders);
    }

    private Collection<Integer> getOutboundPorts(ClientNetworkConfig networkConfig) {
        Collection<Integer> outboundPorts = networkConfig.getOutboundPorts();
        Collection<String> outboundPortDefinitions = networkConfig.getOutboundPortDefinitions();
        return AddressUtil.getOutboundPorts(outboundPorts, outboundPortDefinitions);
    }

    private ClientConnectionStrategy initializeStrategy(HazelcastClientInstanceImpl client) {
        String className = client.getProperties().get("hazelcast.client.connection.strategy.classname");
        if (className != null) {
            try {
                ClassLoader configClassLoader = client.getClientConfig().getClassLoader();
                return (ClientConnectionStrategy)ClassLoaderUtil.newInstance((ClassLoader)configClassLoader, (String)className);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        DefaultClientConnectionStrategy strategy = new DefaultClientConnectionStrategy();
        return strategy;
    }

    public NioNetworking getNetworking() {
        return this.networking;
    }

    protected NioNetworking initNetworking(HazelcastClientInstanceImpl client) {
        HazelcastProperties properties = client.getProperties();
        SSLConfig sslConfig = client.getClientConfig().getNetworkConfig().getSSLConfig();
        boolean sslEnabled = sslConfig != null && sslConfig.isEnabled();
        int configuredInputThreads = properties.getInteger(ClientProperty.IO_INPUT_THREAD_COUNT);
        int configuredOutputThreads = properties.getInteger(ClientProperty.IO_OUTPUT_THREAD_COUNT);
        int inputThreads = configuredInputThreads == -1 ? (sslEnabled ? 3 : 1) : configuredInputThreads;
        int outputThreads = configuredOutputThreads == -1 ? (sslEnabled ? 3 : 1) : configuredOutputThreads;
        return new NioNetworking(new NioNetworking.Context().loggingService(client.getLoggingService()).metricsRegistry((MetricsRegistry)client.getMetricsRegistry()).threadNamePrefix(client.getName()).errorHandler((ChannelErrorHandler)new ClientConnectionChannelErrorHandler()).inputThreadCount(inputThreads).outputThreadCount(outputThreads).balancerIntervalSeconds(properties.getInteger(ClientProperty.IO_BALANCER_INTERVAL_SECONDS)).channelInitializer(client.getClientExtension().createChannelInitializer()));
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        if (sic != null && sic.isEnabled()) {
            ClientExtension clientExtension = this.client.getClientExtension();
            return clientExtension.createSocketInterceptor();
        }
        return null;
    }

    public ClientConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    @Override
    public Collection<ClientConnection> getActiveConnections() {
        return this.activeConnections.values();
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    public synchronized void start(ClientContext clientContext) {
        if (this.alive) {
            return;
        }
        this.alive = true;
        this.startNetworking();
        this.heartbeat.start();
        this.connectionStrategy.init(clientContext);
        this.connectionStrategy.start();
    }

    protected void startNetworking() {
        this.networking.start();
    }

    public synchronized void shutdown() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        for (Connection connection : this.activeConnections.values()) {
            connection.close("Hazelcast client is shutting down", null);
        }
        this.clusterConnector.shutdown();
        this.stopNetworking();
        this.connectionListeners.clear();
        this.heartbeat.shutdown();
        this.connectionStrategy.shutdown();
    }

    @Override
    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    private void setPrincipal(ClientPrincipal principal) {
        this.principal = principal;
    }

    protected void stopNetworking() {
        this.networking.shutdown();
    }

    @Override
    public Connection getActiveConnection(Address target) {
        if (target == null) {
            return null;
        }
        return (Connection)this.activeConnections.get(target);
    }

    @Override
    public Connection getOrConnect(Address address) throws IOException {
        return this.getOrConnect(address, false);
    }

    @Override
    public Connection getOrTriggerConnect(Address target, boolean acquiresResources) throws IOException {
        Connection connection = this.getConnection(target, false, acquiresResources);
        if (connection != null) {
            return connection;
        }
        this.triggerConnect(target, false);
        return null;
    }

    private Connection getConnection(Address target, boolean asOwner, boolean acquiresResources) throws IOException {
        this.checkAllowed(target, asOwner, acquiresResources);
        if (target == null) {
            throw new IllegalStateException("Address can not be null");
        }
        ClientConnection connection = (ClientConnection)this.activeConnections.get(target);
        if (connection != null) {
            if (!asOwner) {
                return connection;
            }
            if (connection.isAuthenticatedAsOwner()) {
                return connection;
            }
        }
        return null;
    }

    private void checkAllowed(Address target, boolean asOwner, boolean acquiresResources) throws IOException {
        if (asOwner) {
            this.connectionStrategy.beforeConnectToCluster(target);
            return;
        }
        try {
            this.connectionStrategy.beforeGetConnection(target);
        }
        catch (HazelcastClientOfflineException e) {
            if (this.allowInvokeWhenDisconnected && !acquiresResources) {
                return;
            }
            throw e;
        }
        if (this.getOwnerConnection() == null) {
            if (this.allowInvokeWhenDisconnected && !acquiresResources) {
                return;
            }
            throw new IOException("Owner connection is not available!");
        }
    }

    @Override
    public Address getOwnerConnectionAddress() {
        return this.clusterConnector.getOwnerConnectionAddress();
    }

    Connection getOrConnect(Address address, boolean asOwner) {
        try {
            ClientConnection connection;
            do {
                if ((connection = (ClientConnection)this.getConnection(address, asOwner, true)) != null) {
                    return connection;
                }
                AuthenticationFuture future = this.triggerConnect(address, asOwner);
                connection = (ClientConnection)future.get();
                if (asOwner) continue;
                return connection;
            } while (!connection.isAuthenticatedAsOwner());
            return connection;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private AuthenticationFuture triggerConnect(Address target, boolean asOwner) {
        if (!asOwner) {
            this.connectionStrategy.beforeOpenConnection(target);
        }
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!");
        }
        AuthenticationFuture future = new AuthenticationFuture();
        AuthenticationFuture oldFuture = this.connectionsInProgress.putIfAbsent(target, future);
        if (oldFuture == null) {
            this.executionService.execute(new InitConnectionTask(target, asOwner, future));
            return future;
        }
        return oldFuture;
    }

    @Override
    public ClientConnection getOwnerConnection() {
        Address ownerConnectionAddress = this.clusterConnector.getOwnerConnectionAddress();
        if (ownerConnectionAddress == null) {
            return null;
        }
        return (ClientConnection)this.getActiveConnection(ownerConnectionAddress);
    }

    private void fireConnectionAddedEvent(ClientConnection connection) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionAdded((Connection)connection);
        }
        this.connectionStrategy.onConnect(connection);
    }

    private void fireConnectionRemovedEvent(ClientConnection connection) {
        if (connection.isAuthenticatedAsOwner()) {
            this.clusterConnector.disconnectFromCluster(connection);
        }
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connectionRemoved((Connection)connection);
        }
        this.connectionStrategy.onDisconnect(connection);
    }

    private boolean useAnyOutboundPort() {
        return this.outboundPortCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireOutboundPort() {
        if (this.outboundPortCount == 0) {
            return 0;
        }
        LinkedList<Integer> linkedList = this.outboundPorts;
        synchronized (linkedList) {
            Integer port = this.outboundPorts.removeFirst();
            this.outboundPorts.addLast(port);
            return port;
        }
    }

    private void bindSocketToPort(Socket socket) throws IOException {
        if (!this.useAnyOutboundPort()) {
            int retryCount = this.outboundPortCount * 2;
            IOException ex = null;
            for (int i = 0; i < retryCount; ++i) {
                int port = this.acquireOutboundPort();
                if (port == 0) {
                    return;
                }
                InetSocketAddress socketAddress = new InetSocketAddress(port);
                try {
                    socket.bind(socketAddress);
                    return;
                }
                catch (IOException e) {
                    ex = e;
                    this.logger.finest("Could not bind port[ " + port + "]: " + e.getMessage());
                    continue;
                }
            }
            throw ex;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(0);
        socket.bind(socketAddress);
    }

    protected ClientConnection createSocketConnection(Address remoteAddress) throws IOException {
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!");
        }
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            this.bindSocketToPort(socket);
            Channel channel = this.networking.register(socketChannel, true);
            channel.connect(remoteAddress.getInetSocketAddress(), this.connectionTimeoutMillis);
            ClientConnection connection = new ClientConnection(this.client, this.connectionIdGen.incrementAndGet(), channel);
            socketChannel.configureBlocking(true);
            if (this.socketInterceptor != null) {
                this.socketInterceptor.onConnect(socket);
            }
            channel.start();
            return connection;
        }
        catch (Exception e) {
            IOUtil.closeResource((Closeable)socketChannel);
            throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
        }
    }

    void onClose(Connection connection) {
        this.removeFromActiveConnections(connection);
    }

    private void removeFromActiveConnections(Connection connection) {
        Address endpoint = connection.getEndPoint();
        if (endpoint == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Destroying " + connection + ", but it has end-point set to null -> not removing it from a connection map");
            }
            return;
        }
        if (this.activeConnections.remove(endpoint, connection)) {
            this.logger.info("Removed connection to endpoint: " + endpoint + ", connection: " + connection);
            this.fireConnectionRemovedEvent((ClientConnection)connection);
        } else if (this.logger.isFinestEnabled()) {
            this.logger.finest("Destroying a connection, but there is no mapping " + endpoint + " -> " + connection + " in the connection map.");
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    private void authenticate(Address target, ClientConnection connection, boolean asOwner, AuthenticationFuture future) {
        ClientPrincipal principal = this.getPrincipal();
        ClientMessage clientMessage = this.encodeAuthenticationRequest(asOwner, this.client.getSerializationService(), principal);
        ClientInvocation clientInvocation = new ClientInvocation(this.client, clientMessage, null, connection);
        ClientInvocationFuture invocationFuture = clientInvocation.invokeUrgent();
        ScheduledFuture<?> timeoutTaskFuture = this.executionService.schedule(new TimeoutAuthenticationTask(invocationFuture), this.authenticationTimeout, TimeUnit.MILLISECONDS);
        invocationFuture.andThen(new AuthCallback(connection, asOwner, target, future, timeoutTaskFuture));
    }

    private ClientMessage encodeAuthenticationRequest(boolean asOwner, SerializationService ss, ClientPrincipal principal) {
        ClientMessage clientMessage;
        byte serializationVersion = ((InternalSerializationService)ss).getVersion();
        String uuid = null;
        String ownerUuid = null;
        if (principal != null) {
            uuid = principal.getUuid();
            ownerUuid = principal.getOwnerUuid();
        }
        if (this.credentials.getClass().equals(UsernamePasswordCredentials.class)) {
            UsernamePasswordCredentials cr = (UsernamePasswordCredentials)this.credentials;
            clientMessage = ClientAuthenticationCodec.encodeRequest((String)cr.getUsername(), (String)cr.getPassword(), (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion, (String)BuildInfoProvider.getBuildInfo().getVersion());
        } else {
            Data data = ss.toData((Object)this.credentials);
            clientMessage = ClientAuthenticationCustomCodec.encodeRequest((Data)data, (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion, (String)BuildInfoProvider.getBuildInfo().getVersion());
        }
        return clientMessage;
    }

    private void onAuthenticated(Address target, ClientConnection connection) {
        ClientConnection oldConnection = this.activeConnections.put(connection.getEndPoint(), connection);
        if (oldConnection == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Authentication succeeded for " + connection + " and there was no old connection to this end-point");
            }
            this.fireConnectionAddedEvent(connection);
        } else {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Re-authentication succeeded for " + connection);
            }
            assert (connection.equals(oldConnection));
        }
        this.connectionsInProgress.remove(target);
        this.logger.info("Authenticated with server " + connection.getEndPoint() + ", server version:" + connection.getConnectedServerVersionString() + " Local address: " + connection.getLocalSocketAddress());
        if (!connection.isAlive()) {
            this.removeFromActiveConnections(connection);
        }
    }

    private void onAuthenticationFailed(Address target, ClientConnection connection, Throwable cause) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Authentication of " + connection + " failed.", cause);
        }
        connection.close(null, cause);
        this.connectionsInProgress.remove(target);
    }

    Collection<Address> getPossibleMemberAddresses() {
        return this.clusterConnector.getPossibleMemberAddresses();
    }

    @Override
    public void connectToCluster() {
        this.clusterConnector.connectToCluster();
    }

    @Override
    public Future<Void> connectToClusterAsync() {
        return this.clusterConnector.connectToClusterAsync();
    }

    private class AuthCallback
    implements ExecutionCallback<ClientMessage> {
        private final ClientConnection connection;
        private final boolean asOwner;
        private final Address target;
        private final AuthenticationFuture future;
        private final ScheduledFuture timeoutTaskFuture;

        AuthCallback(ClientConnection connection, boolean asOwner, Address target, AuthenticationFuture future, ScheduledFuture timeoutTaskFuture) {
            this.connection = connection;
            this.asOwner = asOwner;
            this.target = target;
            this.future = future;
            this.timeoutTaskFuture = timeoutTaskFuture;
        }

        public void onResponse(ClientMessage response) {
            ClientAuthenticationCodec.ResponseParameters result;
            this.timeoutTaskFuture.cancel(true);
            try {
                result = ClientAuthenticationCodec.decodeResponse((ClientMessage)response);
            }
            catch (HazelcastException e) {
                this.onFailure(e);
                return;
            }
            AuthenticationStatus authenticationStatus = AuthenticationStatus.getById((int)result.status);
            switch (authenticationStatus) {
                case AUTHENTICATED: {
                    this.connection.setConnectedServerVersion(result.serverHazelcastVersion);
                    this.connection.setRemoteEndpoint(result.address);
                    if (this.asOwner) {
                        this.connection.setIsAuthenticatedAsOwner();
                        ClientPrincipal principal = new ClientPrincipal(result.uuid, result.ownerUuid);
                        ClientConnectionManagerImpl.this.setPrincipal(principal);
                        ClientConnectionManagerImpl.this.clusterConnector.setOwnerConnectionAddress(this.connection.getEndPoint());
                        ClientConnectionManagerImpl.this.logger.info("Setting " + this.connection + " as owner with principal " + principal);
                    }
                    ClientConnectionManagerImpl.this.onAuthenticated(this.target, this.connection);
                    this.future.onSuccess(this.connection);
                    break;
                }
                case CREDENTIALS_FAILED: {
                    this.onFailure((Throwable)((Object)new AuthenticationException("Invalid credentials! Principal: " + ClientConnectionManagerImpl.this.principal)));
                    break;
                }
                default: {
                    this.onFailure((Throwable)((Object)new AuthenticationException("Authentication status code not supported. status: " + authenticationStatus)));
                }
            }
        }

        public void onFailure(Throwable t) {
            this.timeoutTaskFuture.cancel(true);
            ClientConnectionManagerImpl.this.onAuthenticationFailed(this.target, this.connection, t);
            this.future.onFailure(t);
        }
    }

    private class ClientConnectionChannelErrorHandler
    implements ChannelErrorHandler {
        private ClientConnectionChannelErrorHandler() {
        }

        public void onError(Channel channel, Throwable cause) {
            if (channel == null) {
                ClientConnectionManagerImpl.this.logger.severe(cause);
            } else {
                if (cause instanceof OutOfMemoryError) {
                    ClientConnectionManagerImpl.this.logger.severe(cause);
                }
                ClientConnection connection = (ClientConnection)channel.attributeMap().get(ClientConnection.class);
                if (cause instanceof EOFException) {
                    connection.close("Connection closed by the other side", cause);
                } else {
                    connection.close("Exception in " + connection + ", thread=" + Thread.currentThread().getName(), cause);
                }
            }
        }
    }

    private class InitConnectionTask
    implements Runnable {
        private final Address target;
        private final boolean asOwner;
        private final AuthenticationFuture future;

        InitConnectionTask(Address target, boolean asOwner, AuthenticationFuture future) {
            this.target = target;
            this.asOwner = asOwner;
            this.future = future;
        }

        @Override
        public void run() {
            ClientConnection connection;
            try {
                connection = this.getConnection(this.target);
            }
            catch (Exception e) {
                ClientConnectionManagerImpl.this.logger.finest((Throwable)e);
                this.future.onFailure(e);
                ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
                return;
            }
            try {
                ClientConnectionManagerImpl.this.authenticate(this.target, connection, this.asOwner, this.future);
            }
            catch (Exception e) {
                this.future.onFailure(e);
                connection.close("Failed to authenticate connection", e);
                ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
            }
        }

        private ClientConnection getConnection(Address target) throws IOException {
            ClientConnection connection = (ClientConnection)ClientConnectionManagerImpl.this.activeConnections.get(target);
            if (connection != null) {
                return connection;
            }
            Address address = ClientConnectionManagerImpl.this.addressTranslator.translate(target);
            if (address == null) {
                throw new NullPointerException("Address Translator " + ClientConnectionManagerImpl.this.addressTranslator.getClass() + " could not translate address " + target);
            }
            return ClientConnectionManagerImpl.this.createSocketConnection(address);
        }
    }

    private class TimeoutAuthenticationTask
    implements Runnable {
        private final ClientInvocationFuture future;

        TimeoutAuthenticationTask(ClientInvocationFuture future) {
            this.future = future;
        }

        @Override
        public void run() {
            if (this.future.isDone()) {
                return;
            }
            this.future.complete(new TimeoutException("Authentication response did not come back in " + ClientConnectionManagerImpl.this.authenticationTimeout + " millis"));
        }
    }
}

