/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.proxy.ClientReliableMessageRunner;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MessageListener;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.topic.ReliableMessageListener;
import com.hazelcast.topic.TopicOverloadException;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.topic.impl.reliable.MessageRunner;
import com.hazelcast.topic.impl.reliable.ReliableMessageListenerAdapter;
import com.hazelcast.topic.impl.reliable.ReliableTopicMessage;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ClientReliableTopicProxy<E>
extends ClientProxy
implements ITopic<E> {
    private static final int MAX_BACKOFF = 2000;
    private static final int INITIAL_BACKOFF_MS = 100;
    private final ILogger logger;
    private final ConcurrentMap<String, MessageRunner<E>> runnersMap = new ConcurrentHashMap<String, MessageRunner<E>>();
    private final Ringbuffer<ReliableTopicMessage> ringbuffer;
    private final SerializationService serializationService;
    private final ClientReliableTopicConfig config;
    private final Executor executor;
    private final TopicOverloadPolicy overloadPolicy;

    public ClientReliableTopicProxy(String objectId, ClientContext context, HazelcastClientInstanceImpl client) {
        super("hz:impl:reliableTopicService", objectId, context);
        this.ringbuffer = client.getRingbuffer("_hz_rb_" + objectId);
        this.serializationService = client.getSerializationService();
        this.config = client.getClientConfig().getReliableTopicConfig(objectId);
        this.executor = this.getExecutor(this.config, client);
        this.overloadPolicy = this.config.getTopicOverloadPolicy();
        this.logger = client.getLoggingService().getLogger(this.getClass());
    }

    private Executor getExecutor(ClientReliableTopicConfig config, HazelcastClientInstanceImpl client) {
        Executor executor = config.getExecutor();
        if (executor == null) {
            executor = client.getClientExecutionService().getUserExecutor();
        }
        return executor;
    }

    public void publish(E payload) {
        try {
            Data data = this.serializationService.toData(payload);
            ReliableTopicMessage message = new ReliableTopicMessage(data, null);
            switch (this.overloadPolicy) {
                case ERROR: {
                    this.addOrFail(message);
                    break;
                }
                case DISCARD_OLDEST: {
                    this.addOrOverwrite(message);
                    break;
                }
                case DISCARD_NEWEST: {
                    this.ringbuffer.addAsync((Object)message, OverflowPolicy.FAIL).get();
                    break;
                }
                case BLOCK: {
                    this.addWithBackoff(message);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown overloadPolicy:" + this.overloadPolicy);
                }
            }
        }
        catch (Exception e) {
            throw (RuntimeException)ExceptionUtil.peel((Throwable)e, null, (String)("Failed to publish message: " + payload + " to topic:" + this.getName()));
        }
    }

    private Long addOrOverwrite(ReliableTopicMessage message) throws Exception {
        return (Long)this.ringbuffer.addAsync((Object)message, OverflowPolicy.OVERWRITE).get();
    }

    private void addOrFail(ReliableTopicMessage message) throws Exception {
        long sequenceId = (Long)this.ringbuffer.addAsync((Object)message, OverflowPolicy.FAIL).get();
        if (sequenceId == -1L) {
            throw new TopicOverloadException("Failed to publish message: " + message + " on topic:" + this.name);
        }
    }

    private void addWithBackoff(ReliableTopicMessage message) throws Exception {
        long result;
        long timeoutMs = 100L;
        while ((result = ((Long)this.ringbuffer.addAsync((Object)message, OverflowPolicy.FAIL).get()).longValue()) == -1L) {
            TimeUnit.MILLISECONDS.sleep(timeoutMs);
            if ((timeoutMs *= 2L) <= 2000L) continue;
            timeoutMs = 2000L;
        }
    }

    public String addMessageListener(MessageListener<E> listener) {
        Preconditions.checkNotNull(listener, (String)"Null listener is not allowed!");
        String id = UuidUtil.newUnsecureUuidString();
        ReliableMessageListener<E> reliableMessageListener = this.toReliableMessageListener(listener);
        ClientReliableMessageRunner<E> runner = new ClientReliableMessageRunner<E>(id, reliableMessageListener, this.ringbuffer, this.name, this.config.getReadBatchSize(), this.serializationService, this.executor, this.runnersMap, this.logger);
        this.runnersMap.put(id, runner);
        runner.next();
        return id;
    }

    public boolean isListenerCancelled(String registrationID) {
        Preconditions.checkNotNull((Object)registrationID, (String)"registrationId can't be null");
        MessageRunner runner = (MessageRunner)this.runnersMap.get(registrationID);
        if (runner == null) {
            return true;
        }
        return runner.isCancelled();
    }

    private ReliableMessageListener<E> toReliableMessageListener(MessageListener<E> listener) {
        if (listener instanceof ReliableMessageListener) {
            return (ReliableMessageListener)listener;
        }
        return new ReliableMessageListenerAdapter(listener);
    }

    public boolean removeMessageListener(String registrationId) {
        Preconditions.checkNotNull((Object)registrationId, (String)"registrationId can't be null");
        MessageRunner runner = (MessageRunner)this.runnersMap.get(registrationId);
        if (runner == null) {
            return false;
        }
        runner.cancel();
        return true;
    }

    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public Ringbuffer getRingbuffer() {
        return this.ringbuffer;
    }

    public String toString() {
        return "ITopic{name='" + this.name + '\'' + '}';
    }

    @Override
    protected void postDestroy() {
        this.ringbuffer.destroy();
    }
}

