/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TopicAddMessageListenerCodec;
import com.hazelcast.client.impl.protocol.codec.TopicPublishCodec;
import com.hazelcast.client.impl.protocol.codec.TopicRemoveMessageListenerCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.topic.impl.DataAwareMessage;
import com.hazelcast.util.Preconditions;

public class ClientTopicProxy<E>
extends PartitionSpecificClientProxy
implements ITopic<E> {
    public ClientTopicProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    public void publish(E message) {
        Data data = this.toData(message);
        ClientMessage request = TopicPublishCodec.encodeRequest((String)this.name, (Data)data);
        this.invokeOnPartition(request);
    }

    public String addMessageListener(MessageListener<E> listener) {
        Preconditions.checkNotNull(listener, (String)"Null listener is not allowed!");
        TopicItemHandler handler = new TopicItemHandler(listener);
        return this.registerListener(new Codec(), handler);
    }

    public boolean removeMessageListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String toString() {
        return "ITopic{name='" + this.name + '\'' + '}';
    }

    private class Codec
    implements ListenerMessageCodec {
        private Codec() {
        }

        @Override
        public ClientMessage encodeAddRequest(boolean localOnly) {
            return TopicAddMessageListenerCodec.encodeRequest((String)ClientTopicProxy.this.name, (boolean)localOnly);
        }

        @Override
        public String decodeAddResponse(ClientMessage clientMessage) {
            return TopicAddMessageListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
        }

        @Override
        public ClientMessage encodeRemoveRequest(String realRegistrationId) {
            return TopicRemoveMessageListenerCodec.encodeRequest((String)ClientTopicProxy.this.name, (String)realRegistrationId);
        }

        @Override
        public boolean decodeRemoveResponse(ClientMessage clientMessage) {
            return TopicRemoveMessageListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    }

    private final class TopicItemHandler
    extends TopicAddMessageListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final MessageListener<E> listener;

        private TopicItemHandler(MessageListener<E> listener) {
            this.listener = listener;
        }

        public void handle(Data item, long publishTime, String uuid) {
            Member member = ClientTopicProxy.this.getContext().getClusterService().getMember(uuid);
            DataAwareMessage message = new DataAwareMessage(ClientTopicProxy.this.name, item, publishTime, member, ClientTopicProxy.this.getSerializationService());
            this.listener.onMessage((Message)message);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

