/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.util.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.EventListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlClientConfigBuilder
extends AbstractXmlConfigHelper {
    private static final ILogger logger = Logger.getLogger(XmlClientConfigBuilder.class);
    private ClientConfig clientConfig;
    private InputStream in;

    public XmlClientConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig((String)resource);
        if (url == null) {
            throw new IllegalArgumentException("Could not load " + resource);
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null!");
        }
        this.in = new FileInputStream(file);
    }

    public XmlClientConfigBuilder(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(InputStream in) {
        this.in = in;
    }

    public XmlClientConfigBuilder() {
        String configFile = System.getProperty("hazelcast.client.config");
        try {
            URL configurationUrl;
            File configurationFile = null;
            if (configFile != null) {
                configurationFile = new File(configFile);
                logger.info("Using configuration file at " + configurationFile.getAbsolutePath());
                if (!configurationFile.exists()) {
                    String msg = "Config file at '" + configurationFile.getAbsolutePath() + "' doesn't exist.";
                    msg = msg + "\nHazelcast will try to use the hazelcast-client.xml config file in the working directory.";
                    logger.warning(msg);
                    configurationFile = null;
                }
            }
            if (configurationFile == null) {
                configFile = "hazelcast-client-default.xml";
                configurationFile = new File("hazelcast-client-default.xml");
                if (!configurationFile.exists()) {
                    configurationFile = null;
                }
            }
            if (configurationFile != null) {
                logger.info("Using configuration file at " + configurationFile.getAbsolutePath());
                try {
                    this.in = new FileInputStream(configurationFile);
                    configurationUrl = configurationFile.toURI().toURL();
                }
                catch (Exception e) {
                    String msg = "Having problem reading config file at '" + configFile + "'.";
                    msg = msg + "\nException message: " + e.getMessage();
                    msg = msg + "\nHazelcast will try to use the hazelcast-client.xml config file in classpath.";
                    logger.warning(msg);
                    this.in = null;
                }
            }
            if (this.in == null) {
                logger.info("Looking for hazelcast-client.xml config file in classpath.");
                configurationUrl = Config.class.getClassLoader().getResource("hazelcast-client-default.xml");
                if (configurationUrl == null) {
                    throw new IllegalStateException("Cannot find hazelcast-client.xml in classpath, giving up.");
                }
                logger.info("Using configuration file " + configurationUrl.getFile() + " in the classpath.");
                this.in = configurationUrl.openStream();
                if (this.in == null) {
                    throw new IllegalStateException("Cannot read configuration file, giving up.");
                }
            }
        }
        catch (Throwable e) {
            logger.severe("Error while creating configuration:" + e.getMessage(), e);
        }
    }

    public ClientConfig build() {
        return this.build(Thread.currentThread().getContextClassLoader());
    }

    public ClientConfig build(ClassLoader classLoader) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setClassLoader(classLoader);
        try {
            this.parse(clientConfig);
            return clientConfig;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void parse(ClientConfig clientConfig) throws Exception {
        Document doc;
        this.clientConfig = clientConfig;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        try {
            doc = builder.parse(this.in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not parse configuration file, giving up.");
        }
        Element element = doc.getDocumentElement();
        try {
            element.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.handleConfig(element);
    }

    private void handleConfig(Element docElement) throws Exception {
        for (Node node : new AbstractXmlConfigHelper.IterableNodeList(docElement.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName((String)node.getNodeName());
            if ("security".equals(nodeName)) {
                this.handleSecurity(node);
                continue;
            }
            if ("socket-interceptor".equals(nodeName)) {
                this.handleSocketInterceptor(node);
                continue;
            }
            if ("proxy-factories".equals(nodeName)) {
                this.handleProxyFactories(node);
                continue;
            }
            if ("serialization".equals(nodeName)) {
                this.handleSerialization(node);
                continue;
            }
            if ("group".equals(nodeName)) {
                this.handleGroup(node);
                continue;
            }
            if ("listeners".equals(nodeName)) {
                this.handleListeners(node);
                continue;
            }
            if ("network".equals(nodeName)) {
                this.handleNetwork(node);
                continue;
            }
            if ("load-balancer".equals(nodeName)) {
                this.handleLoadBalancer(node);
                continue;
            }
            if (!"near-cache".equals(nodeName)) continue;
            this.handleNearCache(node);
        }
    }

    private void handleNearCache(Node node) {
        String name = this.getAttribute(node, "name");
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(child);
            if ("max-size".equals(nodeName)) {
                nearCacheConfig.setMaxSize(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                nearCacheConfig.setTimeToLiveSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                nearCacheConfig.setMaxIdleSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                nearCacheConfig.setEvictionPolicy(this.getTextContent(child));
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                nearCacheConfig.setInMemoryFormat(MapConfig.InMemoryFormat.valueOf((String)this.getTextContent(child)));
                continue;
            }
            if (!"invalidate-on-change".equals(nodeName)) continue;
            nearCacheConfig.setInvalidateOnChange(Boolean.parseBoolean(this.getTextContent(child)));
        }
        this.clientConfig.addNearCacheConfig(name, nearCacheConfig);
    }

    private void handleLoadBalancer(Node node) {
        String type = this.getAttribute(node, "type");
        if ("random".equals(type)) {
            this.clientConfig.setLoadBalancer(new RandomLB());
        } else if ("round-robin".equals(type)) {
            this.clientConfig.setLoadBalancer(new RoundRobinLB());
        }
    }

    private void handleNetwork(Node node) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(child);
            if ("cluster-members".equals(nodeName)) {
                this.handleClusterMembers(child);
                continue;
            }
            if ("smart-routing".equals(nodeName)) {
                this.clientConfig.setSmart(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("redo-operation".equals(nodeName)) {
                this.clientConfig.setRedoOperation(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("connection-pool-size".equals(nodeName)) {
                this.clientConfig.setConnectionPoolSize(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-timeout".equals(nodeName)) {
                this.clientConfig.setConnectionTimeout(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-period".equals(nodeName)) {
                this.clientConfig.setConnectionAttemptPeriod(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("connection-attempt-limit".equals(nodeName)) {
                this.clientConfig.setConnectionAttemptLimit(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"socket-options".equals(nodeName)) continue;
            this.handleSocketOptions(child);
        }
    }

    private void handleSocketOptions(Node node) {
        SocketOptions socketOptions = this.clientConfig.getSocketOptions();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = this.cleanNodeName(child);
            if ("tcp-no-delay".equals(nodeName)) {
                socketOptions.setSocketTcpNoDelay(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("keep-alive".equals(nodeName)) {
                socketOptions.setSocketKeepAlive(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("reuse-address".equals(nodeName)) {
                socketOptions.setSocketReuseAddress(Boolean.parseBoolean(this.getTextContent(child)));
                continue;
            }
            if ("linger-seconds".equals(nodeName)) {
                socketOptions.setSocketLingerSeconds(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("timeout".equals(nodeName)) {
                socketOptions.setSocketTimeout(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"buffer-size".equals(nodeName)) continue;
            socketOptions.setSocketBufferSize(Integer.parseInt(this.getTextContent(child)));
        }
    }

    private void handleClusterMembers(Node node) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"address".equals(this.cleanNodeName(child))) continue;
            this.clientConfig.addAddress(this.getTextContent(child));
        }
    }

    private void handleListeners(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"listener".equals(this.cleanNodeName(child))) continue;
            String className = this.getTextContent(child);
            this.handleEventListenerInstantiation(className);
        }
    }

    private void handleEventListenerInstantiation(String className) throws Exception {
        ClassLoader classLoader = this.clientConfig.getClassLoader();
        Class<?> listenerClass = classLoader.loadClass(className);
        EventListener listener = (EventListener)listenerClass.newInstance();
        this.clientConfig.getListeners().add(listener);
    }

    private void handleGroup(Node node) {
        for (Node n : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value = this.getTextContent(n).trim();
            String nodeName = XmlClientConfigBuilder.cleanNodeName((String)n.getNodeName());
            if ("name".equals(nodeName)) {
                this.clientConfig.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.clientConfig.getGroupConfig().setPassword(value);
        }
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.clientConfig.getSerializationConfig();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String value;
            String name = this.cleanNodeName(child);
            if ("portable-version".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setPortableVersion(this.getIntegerValue(name, value, 0));
                continue;
            }
            if ("check-class-def-errors".equals(name)) {
                value = this.getTextContent(child);
                serializationConfig.setCheckClassDefErrors(this.checkTrue(value));
                continue;
            }
            if ("use-native-byte-order".equals(name)) {
                serializationConfig.setUseNativeByteOrder(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("byte-order".equals(name)) {
                value = this.getTextContent(child);
                ByteOrder byteOrder = null;
                if (ByteOrder.BIG_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(value)) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                serializationConfig.setByteOrder(byteOrder != null ? byteOrder : ByteOrder.BIG_ENDIAN);
                continue;
            }
            if ("enable-compression".equals(name)) {
                serializationConfig.setEnableCompression(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("enable-shared-object".equals(name)) {
                serializationConfig.setEnableSharedObject(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("allow-unsafe".equals(name)) {
                serializationConfig.setAllowUnsafe(this.checkTrue(this.getTextContent(child)));
                continue;
            }
            if ("data-serializable-factories".equals(name)) {
                this.handleDataSerializableFactories(child, serializationConfig);
                continue;
            }
            if ("portable-factories".equals(name)) {
                this.handlePortableFactories(child, serializationConfig);
                continue;
            }
            if (!"serializers".equals(name)) continue;
            this.handleSerializers(child, serializationConfig);
        }
    }

    private void handleDataSerializableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(child);
            if (!"data-serializable-factory".equals(name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = child.getAttributes().getNamedItem("factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'data-serializable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addDataSerializableFactoryClass(factoryId, value);
        }
    }

    private void handlePortableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(child);
            if (!"portable-factory".equals(name)) continue;
            String value = this.getTextContent(child);
            Node factoryIdNode = child.getAttributes().getNamedItem("factory-id");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'portable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            serializationConfig.addPortableFactoryClass(factoryId, value);
        }
    }

    private void handleSerializers(Node node, SerializationConfig serializationConfig) {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String name = this.cleanNodeName(child);
            String value = this.getTextContent(child);
            if ("serializer".equals(name)) {
                SerializerConfig serializerConfig = new SerializerConfig();
                serializerConfig.setClassName(value);
                String typeClassName = this.getAttribute(child, "type-class");
                serializerConfig.setTypeClassName(typeClassName);
                serializationConfig.addSerializerConfig(serializerConfig);
                continue;
            }
            if (!"global-serializer".equals(name)) continue;
            GlobalSerializerConfig globalSerializerConfig = new GlobalSerializerConfig();
            globalSerializerConfig.setClassName(value);
            serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
        }
    }

    private void handleProxyFactories(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName((String)child.getNodeName());
            if (!"proxy-factory".equals(nodeName)) continue;
            this.handleProxyFactory(child);
        }
    }

    private void handleProxyFactory(Node node) throws Exception {
        String service = this.getAttribute(node, "service");
        String className = this.getAttribute(node, "class-name");
        this.handleProxyFactoryInstantiation(service, className);
    }

    private void handleProxyFactoryInstantiation(String service, String className) throws Exception {
        ClassLoader classLoader = this.clientConfig.getClassLoader();
        Class<?> proxyFactoryClass = classLoader.loadClass(className);
        ClientProxyFactory factory = (ClientProxyFactory)proxyFactoryClass.newInstance();
        this.clientConfig.getProxyFactoryConfig().addProxyFactory(service, factory);
    }

    private void handleSocketInterceptor(Node node) throws Exception {
        String className = this.getAttribute(node, "class-name");
        this.handleSocketInterceptorInstantiation(className);
    }

    private void handleSocketInterceptorInstantiation(String className) throws Exception {
        ClassLoader classLoader = this.clientConfig.getClassLoader();
        Class<?> socketInterceptorClass = classLoader.loadClass(className);
        SocketInterceptor interceptor = (SocketInterceptor)socketInterceptorClass.newInstance();
        this.clientConfig.setSocketInterceptor(interceptor);
    }

    private void handleSecurity(Node node) throws Exception {
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName((String)child.getNodeName());
            if (!"login-credentials".equals(nodeName)) continue;
            this.handleLoginCredentials(child);
        }
    }

    private void handleLoginCredentials(Node node) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials();
        for (Node child : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            String nodeName = XmlClientConfigBuilder.cleanNodeName((String)child.getNodeName());
            if ("username".equals(nodeName)) {
                credentials.setUsername(this.getTextContent(child));
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            credentials.setPassword(this.getTextContent(child));
        }
        this.clientConfig.setCredentials((Credentials)credentials);
    }

    private String getAttribute(Node node, String attName) {
        Node attNode = node.getAttributes().getNamedItem(attName);
        if (attNode == null) {
            return null;
        }
        return this.getTextContent(attNode);
    }

    private int getIntegerValue(String parameterName, String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            logger.info(parameterName + " parameter value, [" + value + "], is not a proper integer. Default value, [" + defaultValue + "], will be used!");
            logger.warning((Throwable)e);
            return defaultValue;
        }
    }
}

