/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.client.AddAllRequest;
import com.hazelcast.collection.operations.client.AddItemListenerRequest;
import com.hazelcast.collection.operations.client.CollectionDestroyRequest;
import com.hazelcast.collection.operations.client.CompareAndRemoveRequest;
import com.hazelcast.collection.operations.client.ContainsAllRequest;
import com.hazelcast.collection.operations.client.ContainsEntryRequest;
import com.hazelcast.collection.operations.client.CountRequest;
import com.hazelcast.collection.operations.client.GetAllRequest;
import com.hazelcast.collection.operations.client.GetRequest;
import com.hazelcast.collection.operations.client.IndexOfRequest;
import com.hazelcast.collection.operations.client.PutRequest;
import com.hazelcast.collection.operations.client.RemoveAllRequest;
import com.hazelcast.collection.operations.client.RemoveIndexRequest;
import com.hazelcast.collection.operations.client.RemoveRequest;
import com.hazelcast.collection.operations.client.SetRequest;
import com.hazelcast.core.IList;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.PortableItemEvent;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ClientListProxy<E>
extends ClientProxy
implements IList<E> {
    final CollectionProxyId proxyId;
    Data key;

    public ClientListProxy(String serviceName, CollectionProxyId objectId) {
        super(serviceName, objectId);
        this.proxyId = objectId;
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        AddItemListenerRequest request = new AddItemListenerRequest(this.proxyId, this.getKey(), includeValue);
        EventHandler<PortableItemEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, this.getKey(), handler);
    }

    public boolean removeItemListener(String registrationId) {
        return this.stopListening(registrationId);
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        ArrayList<Data> list = new ArrayList<Data>(c.size());
        for (E e : c) {
            Data data = this.getSerializationService().toData(e);
            list.add(data);
        }
        AddAllRequest request = new AddAllRequest(this.proxyId, this.getKey(), ThreadUtil.getThreadId(), list, index);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public E get(int index) {
        GetRequest request = new GetRequest(this.proxyId, this.getKey(), index);
        return (E)this.invoke(request);
    }

    public E set(int index, E element) {
        Data valueData = this.getSerializationService().toData(element);
        SetRequest request = new SetRequest(this.proxyId, this.getKey(), valueData, index, ThreadUtil.getThreadId());
        return (E)this.invoke(request);
    }

    public void add(int index, E element) {
        Data valueData = this.getSerializationService().toData(element);
        PutRequest request = new PutRequest(this.proxyId, this.getKey(), valueData, index, ThreadUtil.getThreadId());
        this.invoke(request);
    }

    public E remove(int index) {
        RemoveIndexRequest request = new RemoveIndexRequest(this.proxyId, this.getKey(), index, ThreadUtil.getThreadId());
        return (E)this.invoke(request);
    }

    public int indexOf(Object o) {
        Data valueData = this.getSerializationService().toData(o);
        IndexOfRequest request = new IndexOfRequest(this.proxyId, this.getKey(), valueData, false);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    public int lastIndexOf(Object o) {
        Data valueData = this.getSerializationService().toData(o);
        IndexOfRequest request = new IndexOfRequest(this.proxyId, this.getKey(), valueData, true);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    public ListIterator<E> listIterator() {
        return this.getList().listIterator();
    }

    public ListIterator<E> listIterator(int index) {
        return this.getList().listIterator(index);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    public int size() {
        CountRequest request = new CountRequest(this.proxyId, this.getKey());
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        Data valueData = this.getSerializationService().toData(o);
        ContainsEntryRequest request = new ContainsEntryRequest(this.proxyId, this.getKey(), valueData);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public Iterator<E> iterator() {
        return this.getList().iterator();
    }

    public Object[] toArray() {
        return this.getList().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getList().toArray(a);
    }

    public boolean add(E e) {
        Data valueData = this.getSerializationService().toData(e);
        PutRequest request = new PutRequest(this.proxyId, this.getKey(), valueData, -1, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public boolean remove(Object o) {
        Data valueData = this.getSerializationService().toData(o);
        RemoveRequest request = new RemoveRequest(this.proxyId, this.getKey(), valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public boolean containsAll(Collection<?> c) {
        HashSet<Data> set = new HashSet<Data>(c.size());
        for (Object o : c) {
            Data data = this.getSerializationService().toData(o);
            set.add(data);
        }
        ContainsAllRequest request = new ContainsAllRequest(this.proxyId, this.getKey(), set);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public boolean addAll(Collection<? extends E> c) {
        ArrayList<Data> list = new ArrayList<Data>(c.size());
        for (E e : c) {
            Data data = this.getSerializationService().toData(e);
            list.add(data);
        }
        AddAllRequest request = new AddAllRequest(this.proxyId, this.getKey(), ThreadUtil.getThreadId(), list);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public boolean removeAll(Collection<?> c) {
        ArrayList<Data> list = new ArrayList<Data>(c.size());
        for (Object o : c) {
            Data data = this.getSerializationService().toData(o);
            list.add(data);
        }
        CompareAndRemoveRequest request = new CompareAndRemoveRequest(this.proxyId, this.getKey(), list, false, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public boolean retainAll(Collection<?> c) {
        ArrayList<Data> list = new ArrayList<Data>(c.size());
        for (Object o : c) {
            Data data = this.getSerializationService().toData(o);
            list.add(data);
        }
        CompareAndRemoveRequest request = new CompareAndRemoveRequest(this.proxyId, this.getKey(), list, true, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public void clear() {
        RemoveAllRequest request = new RemoveAllRequest(this.proxyId, this.getKey(), ThreadUtil.getThreadId());
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
        CollectionDestroyRequest request = new CollectionDestroyRequest(this.proxyId);
        this.invoke(request);
    }

    public String getName() {
        return this.proxyId.getKeyName();
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getSerializationService().toData((Object)this.proxyId.getKeyName());
        }
        return this.key;
    }

    private List<E> getList() {
        GetAllRequest request = new GetAllRequest(this.proxyId, this.getKey());
        PortableCollection result = (PortableCollection)this.invoke(request);
        Collection collection = result.getCollection();
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (Data data : collection) {
            list.add(this.getSerializationService().toObject(data));
        }
        return list;
    }

    private SerializationService getSerializationService() {
        return this.getContext().getSerializationService();
    }

    private EventHandler<PortableItemEvent> createHandler(final ItemListener<E> listener, final boolean includeValue) {
        return new EventHandler<PortableItemEvent>(){

            @Override
            public void handle(PortableItemEvent event) {
                Object item = null;
                if (includeValue) {
                    item = ClientListProxy.this.getSerializationService().toObject(event.getItem());
                }
                MemberImpl member = ClientListProxy.this.getContext().getClusterService().getMember(event.getUuid());
                ItemEvent itemEvent = new ItemEvent(ClientListProxy.this.proxyId.getKeyName(), event.getEventType(), item, (Member)member);
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.itemAdded(itemEvent);
                        break;
                    }
                    case REMOVED: {
                        listener.itemRemoved(itemEvent);
                    }
                }
            }
        };
    }
}

