/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;

public class ClientConfig {
    private GroupConfig groupConfig = new GroupConfig();
    private final List<String> addressList = new ArrayList<String>(10);
    private LoadBalancer loadBalancer = new RoundRobinLB();
    private final Collection<EventListener> listeners = new HashSet<EventListener>();
    private boolean smart = false;
    private boolean redoOperation = false;
    private int poolSize = 100;
    private int connectionTimeout = 60000;
    private int connectionAttemptLimit = 2;
    private int connectionAttemptPeriod = 3000;
    private final SocketOptions socketOptions = new SocketOptions();
    private final SerializationConfig serializationConfig = new SerializationConfig();
    private final ProxyFactoryConfig proxyFactoryConfig = new ProxyFactoryConfig();
    private SocketInterceptor socketInterceptor = null;
    private ManagedContext managedContext = null;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Credentials credentials;

    public boolean isSmart() {
        return this.smart;
    }

    public void setSmart(boolean smart) {
        this.smart = smart;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public SocketInterceptor getSocketInterceptor() {
        return this.socketInterceptor;
    }

    public void setSocketInterceptor(SocketInterceptor socketInterceptor) {
        this.socketInterceptor = socketInterceptor;
    }

    public int getConnectionAttemptPeriod() {
        return this.connectionAttemptPeriod;
    }

    public ClientConfig setConnectionAttemptPeriod(int connectionAttemptPeriod) {
        this.connectionAttemptPeriod = connectionAttemptPeriod;
        return this;
    }

    public int getConnectionAttemptLimit() {
        return this.connectionAttemptLimit;
    }

    public ClientConfig setConnectionAttemptLimit(int connectionAttemptLimit) {
        this.connectionAttemptLimit = connectionAttemptLimit;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Credentials getCredentials() {
        if (this.credentials == null) {
            this.setCredentials((Credentials)new UsernamePasswordCredentials(this.getGroupConfig().getName(), this.getGroupConfig().getPassword()));
        }
        return this.credentials;
    }

    public ClientConfig setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public ClientConfig addAddress(String ... addresses) {
        Collections.addAll(this.addressList, addresses);
        return this;
    }

    public void setAddresses(List<String> addresses) {
        this.addressList.clear();
        for (String address : addresses) {
            this.addressList.addAll(addresses);
        }
    }

    public Collection<String> getAddressList() {
        if (this.addressList.size() == 0) {
            this.addAddress("localhost");
        }
        return this.addressList;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public ClientConfig setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public Collection<EventListener> getListeners() {
        return this.listeners;
    }

    public ClientConfig addListener(EventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public boolean isRedoOperation() {
        return this.redoOperation;
    }

    public void setRedoOperation(boolean redoOperation) {
        this.redoOperation = redoOperation;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public void setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
    }

    public ProxyFactoryConfig getProxyFactoryConfig() {
        return this.proxyFactoryConfig;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }
}

