/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.impl.ClusterOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceListenerManager {
    private final List<InstanceListener> instanceListeners = new CopyOnWriteArrayList<InstanceListener>();
    private final HazelcastClient client;

    public InstanceListenerManager(HazelcastClient client) {
        this.client = client;
    }

    public void registerListener(InstanceListener listener) {
        this.instanceListeners.add(listener);
    }

    public void removeListener(InstanceListener instanceListener) {
        this.instanceListeners.remove(instanceListener);
    }

    public synchronized boolean noListenerRegistered() {
        return this.instanceListeners.isEmpty();
    }

    public void notifyListeners(Packet packet) {
        String id = (String)IOUtil.toObject(packet.getKey());
        int i = (Integer)IOUtil.toObject(packet.getValue());
        InstanceEvent.InstanceEventType instanceEventType = i == 0 ? InstanceEvent.InstanceEventType.CREATED : InstanceEvent.InstanceEventType.DESTROYED;
        InstanceEvent event = new InstanceEvent(instanceEventType, (Instance)this.client.getClientProxy(id));
        for (InstanceListener listener : this.instanceListeners) {
            switch (instanceEventType) {
                case CREATED: {
                    listener.instanceCreated(event);
                    break;
                }
                case DESTROYED: {
                    listener.instanceDestroyed(event);
                    break;
                }
            }
        }
    }

    public Call createNewAddListenerCall(ProxyHelper proxyHelper) {
        Packet request = proxyHelper.createRequestPacket(ClusterOperation.CLIENT_ADD_INSTANCE_LISTENER, null, null);
        return proxyHelper.createCall(request);
    }

    public Collection<Call> calls(HazelcastClient client) {
        if (this.instanceListeners.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createNewAddListenerCall(new ProxyHelper("", client)));
    }
}

