/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Instance;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.monitor.LocalAtomicNumberStats;

public class AtomicNumberClientProxy
implements AtomicNumber {
    private final String name;
    private final ProxyHelper proxyHelper;

    public AtomicNumberClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(this.getName(), hazelcastClient);
    }

    public long addAndGet(long delta) {
        return (Long)this.proxyHelper.doOp(ClusterOperation.ATOMIC_NUMBER_ADD_AND_GET, 0L, delta);
    }

    public boolean compareAndSet(long expect, long update) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.ATOMIC_NUMBER_COMPARE_AND_SET, expect, update);
    }

    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    public long get() {
        return this.getAndAdd(0L);
    }

    public long getAndAdd(long delta) {
        return (Long)this.proxyHelper.doOp(ClusterOperation.ATOMIC_NUMBER_GET_AND_ADD, 0L, delta);
    }

    public long getAndSet(long newValue) {
        return (Long)this.proxyHelper.doOp(ClusterOperation.ATOMIC_NUMBER_GET_AND_SET, 0L, newValue);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public void set(long newValue) {
        this.getAndSet(newValue);
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.ATOMIC_NUMBER;
    }

    public String getName() {
        return this.name.substring("a:".length());
    }

    @Deprecated
    public boolean weakCompareAndSet(long expect, long update) {
        return this.compareAndSet(expect, update);
    }

    @Deprecated
    public void lazySet(long newValue) {
        this.set(newValue);
    }

    public LocalAtomicNumberStats getLocalAtomicNumberStats() {
        throw new UnsupportedOperationException();
    }
}

