/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.impl.EntryListenerManager;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListenerManager {
    final Map<ItemListener, EntryListener> itemListener2EntryListener = new ConcurrentHashMap<ItemListener, EntryListener>();
    private final EntryListenerManager entryListenerManager;

    public ItemListenerManager(EntryListenerManager entryListenerManager) {
        this.entryListenerManager = entryListenerManager;
    }

    public synchronized <E, V> void registerListener(String name, final ItemListener<V> itemListener) {
        EntryAdapter e = new EntryAdapter<E, V>(){

            public void entryAdded(EntryEvent<E, V> event) {
                itemListener.itemAdded(event.getValue());
            }

            public void entryRemoved(EntryEvent<E, V> event) {
                itemListener.itemRemoved(event.getValue());
            }
        };
        this.entryListenerManager.registerListener(name, null, true, (EntryListener<?, ?>)e);
        this.itemListener2EntryListener.put(itemListener, (EntryListener)e);
    }

    public synchronized void removeListener(String name, ItemListener itemListener) {
        EntryListener entryListener = this.itemListener2EntryListener.remove(itemListener);
        this.entryListenerManager.removeListener(name, null, entryListener);
    }

    public Call createNewAddListenerCall(ProxyHelper proxyHelper, boolean includeValue) {
        Packet request = proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, null, null);
        request.setLongValue(0L);
        return proxyHelper.createCall(request);
    }

    public Collection<Call> calls(HazelcastClient client) {
        return Collections.emptyList();
    }
}

