/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.impl.CollectionWrapper;
import com.hazelcast.client.impl.InstanceListenerManager;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.FactoryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterClientProxy
implements Cluster {
    final ProxyHelper proxyHelper;
    private final HazelcastClient client;

    public ClusterClientProxy(HazelcastClient client) {
        this.client = client;
        this.proxyHelper = new ProxyHelper("", client);
    }

    public Collection<Instance> getInstances() {
        Object[] instances = (Object[])this.proxyHelper.doOp(ClusterOperation.GET_INSTANCES, null, null);
        ArrayList<Instance> list = new ArrayList<Instance>();
        if (instances != null) {
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] instanceof FactoryImpl.ProxyKey) {
                    FactoryImpl.ProxyKey proxyKey = (FactoryImpl.ProxyKey)instances[i];
                    list.add((Instance)this.client.getClientProxy(proxyKey.getKey()));
                    continue;
                }
                list.add((Instance)this.client.getClientProxy(instances[i]));
            }
        }
        return list;
    }

    public void addMembershipListener(MembershipListener listener) {
        ProxyHelper.check((EventListener)listener);
        this.client.getListenerManager().getMembershipListenerManager().registerListener(listener);
    }

    public void removeMembershipListener(MembershipListener listener) {
        this.client.getListenerManager().getMembershipListenerManager().removeListener(listener);
    }

    public Set<Member> getMembers() {
        CollectionWrapper cw = (CollectionWrapper)this.proxyHelper.doOp(ClusterOperation.GET_MEMBERS, null, null);
        return new LinkedHashSet<Member>(cw.getKeys());
    }

    public Member getLocalMember() {
        throw new UnsupportedOperationException();
    }

    public long getClusterTime() {
        return (Long)this.proxyHelper.doOp(ClusterOperation.GET_CLUSTER_TIME, null, null);
    }

    public void addInstanceListener(InstanceListener listener) {
        ProxyHelper.check((EventListener)listener);
        if (this.instanceListenerManager().noListenerRegistered()) {
            Call c = this.instanceListenerManager().createNewAddListenerCall(this.proxyHelper);
            this.proxyHelper.doCall(c);
        }
        this.instanceListenerManager().registerListener(listener);
    }

    public void removeInstanceListener(InstanceListener instanceListener) {
        ProxyHelper.check((EventListener)instanceListener);
        this.instanceListenerManager().removeListener(instanceListener);
    }

    private InstanceListenerManager instanceListenerManager() {
        return this.client.getListenerManager().getInstanceListenerManager();
    }

    public String toString() {
        Set<Member> members = this.getMembers();
        StringBuffer sb = new StringBuffer("Cluster [");
        if (members != null) {
            sb.append(members.size());
            sb.append("] {");
            for (Member member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }
}

