/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.AsyncClientCall;
import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.client.impl.CollectionWrapper;
import com.hazelcast.core.Member;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.query.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyHelper {
    private static final AtomicLong callIdGen = new AtomicLong(0L);
    private final String name;
    private final HazelcastClient client;
    final ILogger logger = Logger.getLogger((String)this.getClass().getName());

    public ProxyHelper(String name, HazelcastClient client) {
        this.name = name == null ? "" : name;
        this.client = client;
    }

    public String getName() {
        return this.name;
    }

    protected Packet callAndGetResult(Packet request) {
        Call c = this.createCall(request);
        return this.doCall(c);
    }

    protected Packet doCall(Call c) {
        this.sendCall(c);
        int timeout = 5;
        int i = 0;
        Object response;
        while ((response = c.getResponse(5L, TimeUnit.SECONDS)) == null) {
            if (i > 0) {
                this.logger.log(Level.INFO, "There is no response for " + c + " in " + 5 * i + " seconds.");
            }
            ++i;
        }
        return (Packet)response;
    }

    public void sendCall(Call c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.client.getOutRunnable().enQueue(c);
    }

    public Call createCall(Packet request) {
        Long id = ProxyHelper.newCallId();
        return new Call(id, request){

            public void onDisconnect(Member member) {
                if (!((ProxyHelper)ProxyHelper.this).client.getOutRunnable().queue.contains(this)) {
                    ProxyHelper.this.logger.log(Level.FINEST, "Re enqueue " + this);
                    ProxyHelper.this.client.getOutRunnable().enQueue(this);
                }
            }
        };
    }

    public static Long newCallId() {
        return callIdGen.incrementAndGet();
    }

    private Packet createRequestPacket() {
        Packet request = new Packet();
        request.setName(this.name);
        request.setThreadId(this.getCurrentThreadId());
        return request;
    }

    public int getCurrentThreadId() {
        return (int)Thread.currentThread().getId();
    }

    public Packet createRequestPacket(ClusterOperation operation, byte[] key, byte[] value) {
        return this.createRequestPacket(operation, key, value, 0L, null);
    }

    private Packet createRequestPacket(ClusterOperation operation, byte[] key, byte[] value, long ttl, TimeUnit timeunit) {
        Packet request = this.createRequestPacket();
        request.setOperation(operation);
        request.setKey(key);
        request.setValue(value);
        if (ttl > 0L && timeunit != null) {
            request.setTimeout(timeunit.toMillis(ttl));
        }
        return request;
    }

    <V> Future<V> doAsync(final ClusterOperation operation, final Object key, final Object value) {
        final int threadId = this.getCurrentThreadId();
        AsyncClientCall call = new AsyncClientCall<V>(){

            @Override
            protected void call() {
                Packet request = ProxyHelper.this.prepareRequest(operation, key, value);
                request.setThreadId(threadId);
                Packet response = ProxyHelper.this.callAndGetResult(request);
                this.setResult(ProxyHelper.this.getValue(response));
            }
        };
        this.client.getDefaultParallelExecutor().execute((Runnable)call);
        return call;
    }

    protected Object doOp(ClusterOperation operation, Object key, Object value) {
        return this.doOp(operation, key, value, 0L, null);
    }

    public Object doOp(ClusterOperation operation, Object key, Object value, long ttl, TimeUnit timeunit) {
        Packet request = this.prepareRequest(operation, key, value, ttl, timeunit);
        Packet response = this.callAndGetResult(request);
        return this.getValue(response);
    }

    private Packet prepareRequest(ClusterOperation operation, Object key, Object value, long ttl, TimeUnit timeunit) {
        byte[] k = null;
        byte[] v = null;
        if (key != null) {
            k = IOUtil.toByte(key);
        }
        if (value != null) {
            v = IOUtil.toByte(value);
        }
        return this.createRequestPacket(operation, k, v, ttl, timeunit);
    }

    protected Packet prepareRequest(ClusterOperation operation, Object key, Object value) {
        return this.prepareRequest(operation, key, value, 0L, null);
    }

    protected Object getValue(Packet response) {
        if (response.getValue() != null) {
            return IOUtil.toObject(response.getValue());
        }
        return null;
    }

    public void destroy() {
        this.doOp(ClusterOperation.DESTROY, null, null);
        this.client.destroy(this.name);
    }

    public <K> Collection<K> keys(Predicate predicate) {
        return ((CollectionWrapper)this.doOp(ClusterOperation.CONCURRENT_MAP_ITERATE_KEYS, null, predicate)).getKeys();
    }

    public <K> Collection<K> entries(Predicate predicate) {
        return ((CollectionWrapper)this.doOp(ClusterOperation.CONCURRENT_MAP_ITERATE_ENTRIES, null, predicate)).getKeys();
    }

    static void check(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Object cannot be null.");
        }
        if (!(obj instanceof Serializable)) {
            throw new IllegalArgumentException(obj.getClass().getName() + " is not Serializable.");
        }
    }

    static void check(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener can not be null");
        }
    }

    static void checkTime(long time, TimeUnit timeunit) {
        if (time < 0L) {
            throw new IllegalArgumentException("Time can not be less than 0.");
        }
        if (timeunit == null) {
            throw new NullPointerException("TimeUnit can not be null.");
        }
    }

    public HazelcastClient getHazelcastClient() {
        return this.client;
    }
}

