/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.util.SimpleBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncClientCall<V>
implements Future<V>,
Runnable {
    BlockingQueue<Object> responseQ = new SimpleBlockingQueue();
    private static final Object NULL = new Object();

    protected abstract void call();

    @Override
    public void run() {
        this.call();
    }

    public void setResult(Object obj) {
        if (obj == null) {
            obj = NULL;
        }
        this.responseQ.offer(obj);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return (V)this.processResult(this.responseQ.take());
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = this.responseQ.poll(timeout, unit);
        if (result == null) {
            throw new TimeoutException();
        }
        return (V)this.processResult(result);
    }

    private Object processResult(Object result) throws ExecutionException {
        if (result == NULL) {
            return null;
        }
        if (result instanceof Throwable) {
            throw new ExecutionException((Throwable)result);
        }
        return result;
    }
}

