/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClusterClientException;
import com.hazelcast.nio.AbstractSerializer;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;

public final class Serializer {
    public static byte[] toByte(Object object) {
        return ClientSerializer.instance.toByte(object);
    }

    public static Object toObject(byte[] bytes) {
        return ClientSerializer.instance.toObject(bytes);
    }

    private static class ClientSerializer
    extends AbstractSerializer {
        private static final AbstractSerializer.TypeSerializer[] serializers = ClientSerializer.sort((AbstractSerializer.TypeSerializer[])new AbstractSerializer.TypeSerializer[]{new ClientDataSerializer(), new AbstractSerializer.ByteArraySerializer(), new AbstractSerializer.LongSerializer(), new AbstractSerializer.IntegerSerializer(), new AbstractSerializer.StringSerializer(), new AbstractSerializer.ClassSerializer(), new AbstractSerializer.DateSerializer(), new AbstractSerializer.BigIntegerSerializer(), new AbstractSerializer.Externalizer(), new AbstractSerializer.ObjectSerializer()});
        static final ClientSerializer instance = new ClientSerializer();

        public ClientSerializer() {
            super(serializers);
        }

        byte[] toByte(Object object) {
            try {
                FastByteArrayOutputStream dos = new FastByteArrayOutputStream();
                this.toByte(dos, object);
                dos.close();
                return dos.toByteArray();
            }
            catch (Throwable e) {
                throw new ClusterClientException(e);
            }
        }

        Object toObject(byte[] bytes) {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            try {
                FastByteArrayInputStream dis = new FastByteArrayInputStream(bytes);
                dis.set(bytes, bytes.length);
                Object object = this.toObject(dis);
                dis.close();
                return object;
            }
            catch (Throwable e) {
                throw new ClusterClientException(e);
            }
        }

        static class ClientDataSerializer
        extends AbstractSerializer.DataSerializer {
            ClientDataSerializer() {
            }

            protected Class classForName(String className) throws ClassNotFoundException {
                String name = className;
                if (name.equals("com.hazelcast.impl.Keys")) {
                    name = "com.hazelcast.client.impl.CollectionWrapper";
                } else if (className.equals("com.hazelcast.impl.CMap$Values")) {
                    name = "com.hazelcast.client.impl.Values";
                }
                return super.classForName(name);
            }

            protected String toClassName(Class clazz) throws ClassNotFoundException {
                String className = super.toClassName(clazz);
                if (!className.startsWith("com.hazelcast.client")) {
                    return className;
                }
                return "com.hazelcast" + className.substring("com.hazelcast.client".length());
            }
        }
    }
}

