/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.BaseManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager
extends ClientRunnable {
    public final Map<String, Map<Object, List<EntryListener<?, ?>>>> entryListeners = new ConcurrentHashMap();
    public final Map<String, List<MessageListener<Object>>> messageListeners = new HashMap<String, List<MessageListener<Object>>>();
    private final BlockingQueue<Call> listenerCalls = new LinkedBlockingQueue<Call>();
    public final Map<String, Map<Object, Call>> callMap = new ConcurrentHashMap<String, Map<Object, Call>>();
    final Map<ItemListener, EntryListener> itemListener2EntryListener = new ConcurrentHashMap<ItemListener, EntryListener>();
    final BlockingQueue<Packet> queue = new LinkedBlockingQueue<Packet>();

    public synchronized void registerEntryListener(String name, Object key, EntryListener<?, ?> entryListener) {
        if (!this.entryListeners.containsKey(name)) {
            this.entryListeners.put(name, new HashMap());
        }
        if (!this.entryListeners.get(name).containsKey(key)) {
            this.entryListeners.get(name).put(key, new ArrayList());
        }
        this.entryListeners.get(name).get(key).add(entryListener);
    }

    public synchronized <E, V> void registerItemListener(String name, final ItemListener<E> itemListener) {
        EntryListener e = new EntryListener<E, V>(){

            public void entryAdded(EntryEvent<E, V> event) {
                itemListener.itemAdded(event.getKey());
            }

            public void entryEvicted(EntryEvent<E, V> event) {
            }

            public void entryRemoved(EntryEvent<E, V> event) {
                itemListener.itemRemoved(event.getKey());
            }

            public void entryUpdated(EntryEvent<E, V> event) {
            }
        };
        this.registerEntryListener(name, null, e);
        this.itemListener2EntryListener.put(itemListener, e);
    }

    public synchronized void registerMessageListener(String name, MessageListener messageListener) {
        if (!this.messageListeners.containsKey(name)) {
            this.messageListeners.put(name, new ArrayList());
        }
        this.messageListeners.get(name).add((MessageListener<Object>)messageListener);
    }

    public synchronized void removeMessageListener(String name, MessageListener messageListener) {
        if (!this.messageListeners.containsKey(name)) {
            return;
        }
        this.messageListeners.get(name).remove(messageListener);
        if (this.messageListeners.get(name).size() == 0) {
            this.messageListeners.remove(name);
        }
    }

    public boolean noMessageListenerRegistered(String name) {
        if (!this.messageListeners.containsKey(name)) {
            return true;
        }
        return this.messageListeners.get(name).size() <= 0;
    }

    public boolean noEntryListenerRegistered(Object key, String name) {
        return this.entryListeners.get(name) == null || this.entryListeners.get(name).get(key) == null || this.entryListeners.get(name).get(key).size() <= 0;
    }

    public synchronized void removeEntryListener(String name, Object key, EntryListener<?, ?> entryListener) {
        Map<Object, List<EntryListener<?, ?>>> m = this.entryListeners.get(name);
        if (m != null) {
            List<EntryListener<?, ?>> list = m.get(key);
            if (list != null) {
                list.remove(entryListener);
                if (m.get(key).size() == 0) {
                    m.remove(key);
                    this.removeListenerCall(name, key);
                }
            }
            if (m.size() == 0) {
                this.entryListeners.remove(name);
            }
        }
    }

    public synchronized void removeItemListener(String name, ItemListener itemListener) {
        EntryListener entryListener = this.itemListener2EntryListener.remove(itemListener);
        this.removeEntryListener(name, null, entryListener);
    }

    private void removeListenerCall(String name, Object key) {
        this.callMap.get(name).remove(key);
        if (this.callMap.get(name).size() == 0) {
            this.callMap.remove(name);
        }
    }

    private void fireEntryEvent(EntryEvent event) {
        String name = event.getName();
        Object key = event.getKey();
        if (this.entryListeners.get(name) != null) {
            this.notifyEntryListeners(event, (Collection)this.entryListeners.get(name).get(null));
            this.notifyEntryListeners(event, (Collection)this.entryListeners.get(name).get(key));
        }
    }

    private void notifyEntryListeners(EntryEvent event, Collection<EntryListener<?, ?>> collection) {
        if (collection == null) {
            return;
        }
        for (EntryListener<?, ?> entryListener : collection) {
            if (event.getEventType().equals((Object)EntryEvent.EntryEventType.ADDED)) {
                entryListener.entryAdded(event);
                continue;
            }
            if (event.getEventType().equals((Object)EntryEvent.EntryEventType.REMOVED)) {
                entryListener.entryRemoved(event);
                continue;
            }
            if (event.getEventType().equals((Object)EntryEvent.EntryEventType.UPDATED)) {
                entryListener.entryUpdated(event);
                continue;
            }
            if (!event.getEventType().equals((Object)EntryEvent.EntryEventType.EVICTED)) continue;
            entryListener.entryEvicted(event);
        }
    }

    public void enqueue(Packet packet) {
        try {
            this.queue.put(packet);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addListenerCall(Call call, String name, Object key) {
        this.listenerCalls.add(call);
        if (!this.callMap.containsKey(name)) {
            this.callMap.put(name, new HashMap());
        }
        if (this.callMap.get(name).containsKey(key)) {
            throw new RuntimeException("There should be mostly one call per (map, key)");
        }
        this.callMap.get(name).put(key, call);
    }

    public BlockingQueue<Call> getListenerCalls() {
        return this.listenerCalls;
    }

    @Override
    protected void customRun() throws InterruptedException {
        Packet packet = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (packet == null) {
            return;
        }
        if (BaseManager.getInstanceType((String)packet.getName()).equals((Object)Instance.InstanceType.TOPIC)) {
            this.notifyMessageListeners(packet);
        } else {
            this.notifyEventListeners(packet);
        }
    }

    private void notifyEventListeners(Packet packet) {
        EntryEvent event = new EntryEvent((Object)packet.getName(), (int)packet.getLongValue(), Serializer.toObject(packet.getKey()), Serializer.toObject(packet.getValue()));
        this.fireEntryEvent(event);
    }

    private void notifyMessageListeners(Packet packet) {
        List<MessageListener<Object>> list = this.messageListeners.get(packet.getName());
        if (list != null) {
            for (MessageListener<Object> messageListener : list) {
                messageListener.onMessage(Serializer.toObject(packet.getKey()));
            }
        }
    }
}

