/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientProxy;
import com.hazelcast.client.EntryHolder;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LightKeySet;
import com.hazelcast.client.LightMultiMapEntrySet;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.ValueCollection;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.impl.ClusterOperation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MultiMapClientProxy
implements ClientProxy,
MultiMap,
EntryHolder {
    private final String name;
    private final ProxyHelper proxyHelper;

    public MultiMapClientProxy(HazelcastClient client, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, client);
    }

    public void setOutRunnable(OutRunnable out) {
        this.proxyHelper.setOutRunnable(out);
    }

    public String getName() {
        return this.name.substring(4);
    }

    public boolean put(Object key, Object value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, key, value);
    }

    public Collection get(Object key) {
        ProxyHelper.check(key);
        return (Collection)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_GET, key, null);
    }

    public boolean remove(Object key, Object value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, key, value);
    }

    public Collection remove(Object key) {
        ProxyHelper.check(key);
        return (Collection)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, key, null);
    }

    public Set keySet() {
        Collection collection = this.proxyHelper.keys(null);
        LightKeySet set = new LightKeySet(this, new HashSet(collection));
        return set;
    }

    public Collection values() {
        Set set = this.entrySet();
        return new ValueCollection(this, set);
    }

    public Set entrySet() {
        Set keySet = this.keySet();
        return new LightMultiMapEntrySet(keySet, this, this.getInstanceType());
    }

    public boolean containsKey(Object key) {
        ProxyHelper.check(key);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS, key, null);
    }

    public boolean containsValue(Object value) {
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, null, value);
    }

    public boolean containsEntry(Object key, Object value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, key, value);
    }

    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SIZE, null, null);
    }

    public void clear() {
        Set keys = this.keySet();
        for (Object key : keys) {
            this.remove(key);
        }
    }

    public int valueCount(Object key) {
        ProxyHelper.check(key);
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, key, null);
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.MULTIMAP;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof MultiMap && o != null) {
            return this.getName().equals(((MultiMap)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

