/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientProxy;
import com.hazelcast.client.ClusterClientProxy;
import com.hazelcast.client.ConnectionManager;
import com.hazelcast.client.ExecutorServiceClientProxy;
import com.hazelcast.client.ExecutorServiceManager;
import com.hazelcast.client.IdGeneratorClientProxy;
import com.hazelcast.client.InRunnable;
import com.hazelcast.client.ListClientProxy;
import com.hazelcast.client.LockClientProxy;
import com.hazelcast.client.MapClientProxy;
import com.hazelcast.client.MultiMapClientProxy;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.PacketReader;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.client.QueueClientProxy;
import com.hazelcast.client.SetClientProxy;
import com.hazelcast.client.ThreadContext;
import com.hazelcast.client.TopicClientProxy;
import com.hazelcast.client.TransactionClientProxy;
import com.hazelcast.client.impl.ListenerManager;
import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Transaction;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastClient
implements HazelcastInstance {
    private static final String MAP_PREFIX = "c:";
    private static final String LIST_PREFIX = "m:l:";
    private static final String SET_PREFIX = "m:s:";
    private static final String QUEUE_PREFIX = "q:";
    private static final String TOPIC_PREFIX = "t:";
    private static final String IDGEN_PREFIX = "i:";
    private static final String MULTIMAP_PROXY = "m:u:";
    final Map<Long, Call> calls = new ConcurrentHashMap<Long, Call>();
    final ListenerManager listenerManager;
    final OutRunnable out;
    final InRunnable in;
    final ConnectionManager connectionManager;
    final Map<String, ClientProxy> mapProxies = new ConcurrentHashMap<String, ClientProxy>(100);
    final ExecutorServiceManager executorServiceManager;
    final IMap mapLockProxy;
    final ClusterClientProxy clusterClientProxy;

    private HazelcastClient(String groupName, String groupPassword, boolean shuffle, InetSocketAddress[] clusterMembers) {
        this.connectionManager = new ConnectionManager(this, clusterMembers, shuffle);
        this.out = new OutRunnable(this, this.calls, new PacketWriter());
        new Thread((Runnable)this.out, "hz.client.OutThread").start();
        this.in = new InRunnable(this, this.calls, new PacketReader());
        new Thread((Runnable)this.in, "hz.client.InThread").start();
        this.listenerManager = new ListenerManager();
        new Thread((Runnable)this.listenerManager, "hz.client.Listener").start();
        try {
            this.connectionManager.getConnection();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this.executorServiceManager = new ExecutorServiceManager(this);
        new Thread((Runnable)this.executorServiceManager, "hz.client.executorManager").start();
        this.mapLockProxy = this.getMap("__hz_Locks");
        this.clusterClientProxy = new ClusterClientProxy(this);
        this.clusterClientProxy.setOutRunnable(this.out);
        Boolean authenticate = this.clusterClientProxy.authenticate(groupName, groupPassword);
        if (!authenticate.booleanValue()) {
            this.shutdown();
            throw new RuntimeException("Wrong group name and password.");
        }
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, String ... addresses) {
        return HazelcastClient.newHazelcastClient(groupName, groupPassword, true, addresses);
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, boolean shuffle, String ... addresses) {
        InetSocketAddress[] socketAddressArr = new InetSocketAddress[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            InetSocketAddress inetSocketAddress;
            String[] seperated = addresses[i].split(":");
            int port = seperated.length > 1 ? Integer.valueOf(seperated[1]) : 5701;
            socketAddressArr[i] = inetSocketAddress = new InetSocketAddress(seperated[0], port);
        }
        return HazelcastClient.newHazelcastClient(groupName, groupPassword, shuffle, socketAddressArr);
    }

    public static HazelcastClient newHazelcastClient(String groupName, String groupPassword, boolean shuffle, InetSocketAddress ... addresses) {
        return new HazelcastClient(groupName, groupPassword, shuffle, addresses);
    }

    public Config getConfig() {
        throw new UnsupportedOperationException();
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getClientProxy(MAP_PREFIX + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V, E> ClientProxy getClientProxy(String name) {
        ClientProxy proxy = this.mapProxies.get(name);
        if (proxy == null) {
            Map<String, ClientProxy> map = this.mapProxies;
            synchronized (map) {
                if (proxy == null) {
                    if (name.startsWith(MAP_PREFIX)) {
                        proxy = new MapClientProxy(this, name);
                    } else if (name.startsWith(LIST_PREFIX)) {
                        proxy = new ListClientProxy(this, name);
                    } else if (name.startsWith(SET_PREFIX)) {
                        proxy = new SetClientProxy(this, name);
                    } else if (name.startsWith(QUEUE_PREFIX)) {
                        proxy = new QueueClientProxy(this, name);
                    } else if (name.startsWith(TOPIC_PREFIX)) {
                        proxy = new TopicClientProxy(this, name);
                    } else if (name.startsWith(IDGEN_PREFIX)) {
                        proxy = new IdGeneratorClientProxy(this, name);
                    } else if (name.startsWith(MULTIMAP_PROXY)) {
                        proxy = new MultiMapClientProxy(this, name);
                    }
                    proxy.setOutRunnable(this.out);
                    this.mapProxies.put(name, proxy);
                }
            }
        }
        return this.mapProxies.get(name);
    }

    public Transaction getTransaction() {
        ThreadContext trc = ThreadContext.get();
        TransactionClientProxy proxy = (TransactionClientProxy)trc.getTransaction();
        proxy.setOutRunnable(this.out);
        return proxy;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void shutdown() {
        this.out.shutdown();
        this.listenerManager.shutdown();
        this.in.shutdown();
        this.executorServiceManager.shutdown();
    }

    public void addInstanceListener(InstanceListener instanceListener) {
        throw new UnsupportedOperationException();
    }

    public Cluster getCluster() {
        return this.clusterClientProxy;
    }

    public ExecutorService getExecutorService() {
        return new ExecutorServiceClientProxy(this);
    }

    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getClientProxy(IDGEN_PREFIX + name);
    }

    public Collection<Instance> getInstances() {
        return this.clusterClientProxy.getInstances();
    }

    public <E> IList<E> getList(String name) {
        return (IList)this.getClientProxy(LIST_PREFIX + name);
    }

    public ILock getLock(Object obj) {
        return new LockClientProxy(obj, this);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getClientProxy(MULTIMAP_PROXY + name);
    }

    public String getName() {
        return null;
    }

    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getClientProxy(QUEUE_PREFIX + name);
    }

    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getClientProxy(SET_PREFIX + name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getClientProxy(TOPIC_PREFIX + name);
    }

    public void removeInstanceListener(InstanceListener instanceListener) {
        throw new UnsupportedOperationException();
    }

    public void restart() {
        throw new UnsupportedOperationException();
    }

    protected void destroy(String proxyName) {
        this.mapProxies.remove(proxyName);
    }
}

