/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientProxy;
import com.hazelcast.client.FutureProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.DistributedTask;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorServiceClientProxy
implements ClientProxy,
ExecutorService {
    final ProxyHelper proxyHelper;
    private final HazelcastClient client;

    public ExecutorServiceClientProxy(HazelcastClient client) {
        this.client = client;
        this.proxyHelper = new ProxyHelper("", client);
    }

    @Override
    public void setOutRunnable(OutRunnable out) {
        this.proxyHelper.setOutRunnable(out);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> Future<T> submit(Callable<T> tCallable) {
        this.check(tCallable);
        FutureProxy<T> future = new FutureProxy<T>(this.proxyHelper, tCallable);
        this.client.executorServiceManager.enqueue(future);
        return future;
    }

    private <T> void check(Object o) {
        if (o == null) {
            throw new NullPointerException("Object cannot be null.");
        }
        if (!(o instanceof Serializable)) {
            throw new IllegalArgumentException(o.getClass().getName() + " is not Serializable.");
        }
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        this.check(runnable);
        DistributedTask.DistributedRunnableAdapterImpl adapter = new DistributedTask.DistributedRunnableAdapterImpl(runnable, t);
        return this.submit((Callable<T>)adapter);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.submit(runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> callables) throws InterruptedException {
        if (callables == null) {
            throw new NullPointerException();
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(callables.size());
        boolean done = false;
        try {
            for (Callable<T> callable : callables) {
                futures.add(this.submit(callable));
            }
            for (Future future : futures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            done = true;
            ArrayList<Future<T>> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<Callable<T>> callables) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    public <T> T invokeAny(Collection<Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable runnable) {
    }
}

