/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.impl.CollectionWrapper;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Instance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.ClusterOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterClientProxy
implements ClientProxy,
Cluster {
    final ProxyHelper proxyHelper;
    private final HazelcastClient client;

    public ClusterClientProxy(HazelcastClient client) {
        this.client = client;
        this.proxyHelper = new ProxyHelper("", client);
    }

    @Override
    public void setOutRunnable(OutRunnable out) {
        this.proxyHelper.setOutRunnable(out);
    }

    public Collection<Instance> getInstances() {
        Object[] instances = (Object[])this.proxyHelper.doOp(ClusterOperation.GET_INSTANCES, null, null);
        ArrayList<Instance> list = new ArrayList<Instance>();
        for (int i = 0; i < instances.length; ++i) {
            list.add((Instance)this.client.getClientProxy((String)instances[i]));
        }
        return list;
    }

    public void addMembershipListener(MembershipListener listener) {
    }

    public void removeMembershipListener(MembershipListener listener) {
    }

    public Set<Member> getMembers() {
        CollectionWrapper cw = (CollectionWrapper)this.proxyHelper.doOp(ClusterOperation.GET_MEMBERS, null, null);
        return new HashSet<Member>(cw.getKeys());
    }

    public Member getLocalMember() {
        throw new UnsupportedOperationException();
    }

    public long getClusterTime() {
        return (Long)this.proxyHelper.doOp(ClusterOperation.GET_CLUSTER_TIME, null, null);
    }

    public boolean authenticate(String groupName, String groupPassword) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CLIENT_AUTHENTICATE, groupName, groupPassword);
    }
}

