/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.impl.EntryListenerManager;
import com.hazelcast.client.impl.InstanceListenerManager;
import com.hazelcast.client.impl.ItemListenerManager;
import com.hazelcast.client.impl.MembershipListenerManager;
import com.hazelcast.client.impl.MessageListenerManager;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.impl.BaseManager;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager
extends ClientRunnable {
    private final HazelcastClient client;
    private final BlockingQueue<Call> listenerCalls = new LinkedBlockingQueue<Call>();
    final BlockingQueue<Packet> queue = new LinkedBlockingQueue<Packet>();
    private final InstanceListenerManager instanceListenerManager;
    private final MembershipListenerManager membershipListenerManager;
    private final MessageListenerManager messageListenerManager;
    private final EntryListenerManager entryListenerManager;
    private final ItemListenerManager itemListenerManager;

    public ListenerManager(HazelcastClient hazelcastClient) {
        this.client = hazelcastClient;
        this.instanceListenerManager = new InstanceListenerManager(this.client);
        this.membershipListenerManager = new MembershipListenerManager(this.client);
        this.messageListenerManager = new MessageListenerManager();
        this.entryListenerManager = new EntryListenerManager();
        this.itemListenerManager = new ItemListenerManager(this.entryListenerManager);
    }

    public void enqueue(Packet packet) {
        try {
            this.queue.put(packet);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addListenerCall(Call call) {
        this.listenerCalls.add(call);
    }

    public BlockingQueue<Call> getListenerCalls() {
        return this.listenerCalls;
    }

    @Override
    protected void customRun() throws InterruptedException {
        try {
            Packet packet = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            if (packet == null) {
                return;
            }
            if (packet.getName() == null) {
                Object eventType = Serializer.toObject(packet.getValue());
                if (eventType instanceof InstanceEvent.InstanceEventType) {
                    this.instanceListenerManager.notifyInstanceListeners(packet);
                } else {
                    this.membershipListenerManager.notifyMembershipListeners(packet);
                }
            } else if (BaseManager.getInstanceType((String)packet.getName()).equals((Object)Instance.InstanceType.TOPIC)) {
                this.messageListenerManager.notifyMessageListeners(packet);
            } else {
                this.entryListenerManager.notifyEntryListeners(packet);
            }
        }
        catch (InterruptedException ine) {
            throw ine;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InstanceListenerManager getInstanceListenerManager() {
        return this.instanceListenerManager;
    }

    public MembershipListenerManager getMembershipListenerManager() {
        return this.membershipListenerManager;
    }

    public MessageListenerManager getMessageListenerManager() {
        return this.messageListenerManager;
    }

    public EntryListenerManager getEntryListenerManager() {
        return this.entryListenerManager;
    }

    public ItemListenerManager getItemListenerManager() {
        return this.itemListenerManager;
    }
}

