/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.ClusterOperation;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicClientProxy<T>
implements ITopic {
    private final String name;
    private final ProxyHelper proxyHelper;

    public TopicClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    public String getName() {
        return this.name.substring(2);
    }

    public void publish(Object message) {
        ProxyHelper.check(message);
        this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_PUBLISH, message, null);
    }

    public void addMessageListener(MessageListener messageListener) {
        ProxyHelper.check((EventListener)messageListener);
        if (this.proxyHelper.getHazelcastClient().listenerManager.messageListenerManager.noMessageListenerRegistered(this.name)) {
            Packet request = this.proxyHelper.prepareRequest(ClusterOperation.ADD_LISTENER, null, null);
            this.proxyHelper.callAndGetResult(request);
            Call c = ProxyHelper.createCall(request);
            this.proxyHelper.getHazelcastClient().listenerManager.addListenerCall(c);
            this.proxyHelper.doCall(c);
        }
        this.proxyHelper.getHazelcastClient().listenerManager.messageListenerManager.registerMessageListener(this.name, messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        ProxyHelper.check((EventListener)messageListener);
        this.proxyHelper.getHazelcastClient().listenerManager.messageListenerManager.removeMessageListener(this.name, messageListener);
        if (this.proxyHelper.getHazelcastClient().listenerManager.messageListenerManager.noMessageListenerRegistered(this.name)) {
            this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, null, null);
        }
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.TOPIC;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof ITopic && o != null) {
            return this.getName().equals(((ITopic)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

