/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.core.Member;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.nio.Address;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class Connection {
    private static final int BUFFER_SIZE = 1024;
    private Socket socket;
    private InetSocketAddress address;
    private int id = -1;
    private DataOutputStream dos;
    private DataInputStream dis;

    public Connection(String host, int port, int id) {
        try {
            this.setSocket(SocketFactory.getDefault().createSocket(host, port));
            this.socket.setKeepAlive(true);
            this.dos = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 1024));
            this.dis = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 1024));
            this.id = id;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection(InetSocketAddress address, int version) {
        this(address.getAddress().getHostAddress(), address.getPort(), version);
        this.address = address;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setVersion(int version) {
        this.id = version;
    }

    public int getVersion() {
        return this.id;
    }

    public String toString() {
        return "Connection [" + this.id + "]" + " [" + this.address + "]";
    }

    public DataOutputStream getOutputStream() {
        return this.dos;
    }

    public DataInputStream getInputStream() {
        return this.dis;
    }

    public Member getMember() {
        return new MemberImpl(new Address(this.address), false);
    }
}

