/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionClientProxy<E>
extends AbstractCollection<E> {
    protected final ProxyHelper proxyHelper;
    protected final String name;

    public CollectionClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    @Override
    public Iterator<E> iterator() {
        final Collection collection = this.proxyHelper.keys(null);
        final CollectionClientProxy proxy = this;
        return new Iterator<E>(){
            Iterator<E> iterator;
            volatile E lastRecord;
            {
                this.iterator = collection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                this.lastRecord = this.iterator.next();
                return this.lastRecord;
            }

            @Override
            public void remove() {
                this.iterator.remove();
                proxy.remove(this.lastRecord);
            }
        };
    }

    @Override
    public String toString() {
        return "CollectionClientProxy{name='" + this.name + '\'' + '}';
    }

    public void addItemListener(ItemListener<E> listener, boolean includeValue) {
        ProxyHelper.check(listener);
        Packet request = this.proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, null, null);
        request.setLongValue(includeValue ? 1L : 0L);
        Call c = ProxyHelper.createCall(request);
        this.proxyHelper.getHazelcastClient().listenerManager.addListenerCall(c);
        this.proxyHelper.doCall(c);
        this.proxyHelper.getHazelcastClient().listenerManager.itemListenerManager.registerItemListener(this.name, listener);
    }

    public void removeItemListener(ItemListener<E> listener) {
        ProxyHelper.check(listener);
        this.proxyHelper.getHazelcastClient().listenerManager.itemListenerManager.removeItemListener(this.name, listener);
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SIZE, null, null);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

