/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.core.EntryEvent;
import com.hazelcast.client.core.EntryListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager
implements Runnable {
    final Map<String, Map<Object, List<EntryListener>>> mapOfListeners = new HashMap<String, Map<Object, List<EntryListener>>>();
    final BlockingQueue<Packet> queue = new LinkedBlockingQueue<Packet>();

    public void registerEntryListener(String name, Object key, EntryListener entryListener) {
        if (!this.mapOfListeners.containsKey(name)) {
            this.mapOfListeners.put(name, new HashMap());
        }
        if (!this.mapOfListeners.get(name).containsKey(key)) {
            this.mapOfListeners.get(name).put(key, new ArrayList());
        }
        this.mapOfListeners.get(name).get(key).add(entryListener);
    }

    private void fireEvent(EntryEvent event) {
        String name = event.getName();
        Object key = event.getKey();
        this.notifyListeners(event, (Collection<EntryListener>)this.mapOfListeners.get(name).get(null));
        this.notifyListeners(event, (Collection<EntryListener>)this.mapOfListeners.get(name).get(key));
    }

    private void notifyListeners(EntryEvent event, Collection<EntryListener> collection) {
        if (collection == null) {
            return;
        }
        for (EntryListener entryListener : collection) {
            if (event.getEventType().equals((Object)EntryEvent.EntryEventType.ADDED)) {
                entryListener.entryAdded(event);
                continue;
            }
            if (event.getEventType().equals((Object)EntryEvent.EntryEventType.REMOVED)) {
                entryListener.entryRemoved(event);
                continue;
            }
            if (event.getEventType().equals((Object)EntryEvent.EntryEventType.UPDATED)) {
                entryListener.entryUpdated(event);
                continue;
            }
            if (!event.getEventType().equals((Object)EntryEvent.EntryEventType.EVICTED)) continue;
            entryListener.entryEvicted(event);
        }
    }

    public void enqueue(Packet packet) {
        try {
            this.queue.put(packet);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            Packet packet = null;
            try {
                packet = this.queue.take();
                EntryEvent event = new EntryEvent(packet.getName(), (int)packet.getLongValue(), Serializer.toObject(packet.getKey()), Serializer.toObject(packet.getValue()));
                this.fireEvent(event);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

