/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.nio.DataSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Serializer {
    private static final byte SERIALIZER_TYPE_DATA = 0;
    private static final byte SERIALIZER_TYPE_OBJECT = 1;
    private static final byte SERIALIZER_TYPE_BYTE_ARRAY = 2;
    private static final byte SERIALIZER_TYPE_INTEGER = 3;
    private static final byte SERIALIZER_TYPE_LONG = 4;
    private static final byte SERIALIZER_TYPE_CLASS = 5;
    private static final byte SERIALIZER_TYPE_STRING = 6;
    private static final int STRING_CHUNK_SIZE = 16384;

    public static byte[] toByte(Object object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (object == null) {
            return new byte[0];
        }
        try {
            if (object instanceof DataSerializable) {
                dos.writeByte(0);
                dos.writeUTF(object.getClass().getName().replaceFirst("com.hazelcast.client", "com.hazelcast"));
                ((DataSerializable)object).writeData(dos);
            } else if (object instanceof String) {
                String string = (String)object;
                dos.writeByte(6);
                int length = string.length();
                int chunkSize = length / 16384 + 1;
                for (int i = 0; i < chunkSize; ++i) {
                    int beginIndex = Math.max(0, i * 16384 - 1);
                    int endIndex = Math.min((i + 1) * 16384 - 1, length);
                    dos.writeUTF(string.substring(beginIndex, endIndex));
                }
            } else if (object instanceof byte[]) {
                byte[] bytes = (byte[])object;
                dos.writeByte(2);
                bos.write(bytes.length);
                bos.write(bytes);
            } else if (object instanceof Integer) {
                dos.writeByte(3);
                dos.writeInt((Integer)object);
            } else if (object instanceof Long) {
                dos.writeByte(4);
                dos.writeLong((Long)object);
            } else if (object instanceof Class) {
                dos.writeByte(5);
                dos.writeUTF(((Class)object).getName());
            } else {
                dos.writeByte(1);
                ObjectOutputStream os = new ObjectOutputStream(dos);
                os.writeObject(object);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    public static Object toObject(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        int type = bis.read();
        try {
            if (type == 0) {
                String className = dis.readUTF();
                DataSerializable data = (DataSerializable)Class.forName(className.replaceFirst("com.hazelcast", "com.hazelcast.client")).newInstance();
                data.readData(dis);
                return data;
            }
            if (type == 6) {
                StringBuilder result = new StringBuilder();
                while (dis.available() > 0) {
                    result.append(dis.readUTF());
                }
                return result.toString();
            }
            if (type == 2) {
                int size = dis.readInt();
                byte[] b = new byte[size];
                bis.read(b);
                return b;
            }
            if (type == 3) {
                return dis.readInt();
            }
            if (type == 4) {
                return dis.readLong();
            }
            if (type == 5) {
                return Class.forName(dis.readUTF());
            }
            if (type == 1) {
                ObjectInputStream os = new ObjectInputStream(dis);
                return os.readObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

