/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.impl.ClusterOperation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet {
    private int headerSize;
    private int keySize;
    private int valueSize;
    private byte[] headerInBytes;
    private byte[] key;
    private byte[] value;
    private String name;
    private ClusterOperation operation;
    private int blockId = 0;
    private int threadId;
    private int lockCount = 0;
    private long timeout = -1L;
    private long txnId = -1L;
    private long longValue;
    private long version = -1L;
    private byte responseType = (byte)2;
    private boolean lockAddressIsNull = true;
    private long callId = -1L;
    private boolean client = true;
    private byte indexCount = 0;
    private long[] indexes = new long[6];
    private byte[] indexTypes = new byte[6];

    public void writeTo(DataOutputStream outputStream) throws IOException {
        this.headerInBytes = this.getHeader();
        this.headerSize = this.headerInBytes.length;
        outputStream.writeInt(this.headerSize);
        outputStream.writeInt(this.keySize);
        outputStream.writeInt(this.valueSize);
        outputStream.write(this.headerInBytes);
        if (this.key != null) {
            outputStream.write(this.key);
        }
        if (this.value != null) {
            outputStream.write(this.value);
        }
    }

    public void readFrom(DataInputStream dis) throws IOException {
        this.headerSize = dis.readInt();
        this.keySize = dis.readInt();
        this.valueSize = dis.readInt();
        this.headerInBytes = new byte[this.headerSize];
        dis.read(this.headerInBytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.headerInBytes);
        DataInputStream dis2 = new DataInputStream(bis);
        this.operation = ClusterOperation.create(dis2.readInt());
        this.blockId = dis2.readInt();
        this.threadId = dis2.readInt();
        this.lockCount = dis2.readInt();
        this.timeout = dis2.readLong();
        this.txnId = dis2.readLong();
        this.longValue = dis2.readLong();
        this.version = dis2.readLong();
        this.callId = (int)dis2.readLong();
        this.client = dis2.readByte() == 1;
        this.responseType = dis2.readByte();
        int nameLength = dis2.readInt();
        byte[] b = new byte[nameLength];
        dis2.read(b);
        this.name = new String(b);
        this.lockAddressIsNull = dis2.readBoolean();
        this.indexCount = dis2.readByte();
        for (int i = 0; i < this.indexCount; ++i) {
            this.indexes[i] = dis2.readLong();
            this.indexTypes[i] = dis2.readByte();
        }
        this.key = new byte[this.keySize];
        dis.read(this.key);
        this.value = new byte[this.valueSize];
        dis.read(this.value);
    }

    private byte[] getHeader() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(this.operation.getValue());
        dos.writeInt(this.blockId);
        dos.writeInt(this.threadId);
        dos.writeInt(this.lockCount);
        dos.writeLong(this.timeout);
        dos.writeLong(this.txnId);
        dos.writeLong(this.longValue);
        dos.writeLong(this.version);
        dos.writeLong(this.callId);
        dos.writeByte(this.client ? 1 : 0);
        dos.writeByte(this.responseType);
        byte[] nameInBytes = this.name.getBytes();
        dos.writeInt(nameInBytes.length);
        dos.write(nameInBytes);
        dos.writeBoolean(this.lockAddressIsNull);
        dos.writeByte(this.indexCount);
        for (int i = 0; i < this.indexCount; ++i) {
            dos.writeLong(this.indexes[i]);
            dos.writeByte(this.indexTypes[i]);
        }
        return bos.toByteArray();
    }

    public void set(String name, ClusterOperation operation, byte[] key, byte[] value) {
        this.name = name;
        this.operation = operation;
        this.setKey(key);
        this.setValue(value);
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public void setValueSize(int valueSize) {
        this.valueSize = valueSize;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
        this.keySize = this.key.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
        this.valueSize = this.value.length;
    }

    public void setCallId(long callid) {
        this.callId = callid;
    }

    public long getCallId() {
        return this.callId;
    }

    public byte[] getHeaderInBytes() {
        return this.headerInBytes;
    }

    public void setHeaderInBytes(byte[] headerInBytes) {
        this.headerInBytes = headerInBytes;
        this.headerSize = headerInBytes.length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ClusterOperation operation) {
        this.operation = operation;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getLockCount() {
        return this.lockCount;
    }

    public void setLockCount(int lockCount) {
        this.lockCount = lockCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public void setTxnId(long txnId) {
        this.txnId = txnId;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public byte getResponseType() {
        return this.responseType;
    }

    public void setResponseType(byte responseType) {
        this.responseType = responseType;
    }

    public boolean isLockAddressIsNull() {
        return this.lockAddressIsNull;
    }

    public void setLockAddressIsNull(boolean lockAddressIsNull) {
        this.lockAddressIsNull = lockAddressIsNull;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public boolean isClient() {
        return this.client;
    }

    public byte getIndexCount() {
        return this.indexCount;
    }

    public void setIndexCount(byte indexCount) {
        this.indexCount = indexCount;
    }

    public long[] getIndexes() {
        return this.indexes;
    }

    public void setIndexes(long[] indexes) {
        this.indexes = indexes;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public void setIndexTypes(byte[] indexTypes) {
        this.indexTypes = indexTypes;
    }
}

