/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.InRunnable;
import com.hazelcast.client.MapClientProxy;
import com.hazelcast.client.OutRunnable;
import com.hazelcast.client.Packet;
import com.hazelcast.client.PacketReader;
import com.hazelcast.client.PacketWriter;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.TransactionClientProxy;
import com.hazelcast.client.cluster.Bind;
import com.hazelcast.client.core.IMap;
import com.hazelcast.client.core.Transaction;
import com.hazelcast.client.impl.ClusterOperation;
import com.hazelcast.client.impl.ListenerManager;
import com.hazelcast.client.nio.Address;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastClient {
    Map<Long, Call> calls = new HashMap<Long, Call>();
    ListenerManager listenerManager = new ListenerManager();
    OutRunnable out;
    InRunnable in;
    PacketWriter writer;
    PacketReader reader;
    Connection connection;
    private List<InetSocketAddress> clusterMembers = new ArrayList<InetSocketAddress>();

    private HazelcastClient(InetSocketAddress[] clusterMembers) {
        this.clusterMembers.addAll(Arrays.asList(clusterMembers));
        Collections.shuffle(this.clusterMembers);
        this.writer = new PacketWriter();
        this.reader = new PacketReader();
        this.connection = this.searchForAvailableConnection();
        this.writer.setConnection(this.connection);
        this.reader.setConnection(this.connection);
        this.out = new OutRunnable();
        this.out.setCallMap(this.calls);
        this.out.setPacketWriter(this.writer);
        new Thread(this.out).start();
        this.in = new InRunnable(this, this.reader);
        this.in.setCallMap(this.calls);
        new Thread(this.in).start();
        this.sendBindRequest(this.connection.getAddress(), this.connection);
        new Thread(this.listenerManager).start();
    }

    public static HazelcastClient getHazelcastClient(InetSocketAddress ... clusterMembers) {
        return new HazelcastClient(clusterMembers);
    }

    private void sendBindRequest(InetSocketAddress address, Connection connection) {
        Bind b = null;
        try {
            b = new Bind(new Address(address.getHostName(), connection.getSocket().getLocalPort()));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        Packet bind = new Packet();
        bind.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, Serializer.toByte(null), Serializer.toByte(b));
        Call cBind = new Call();
        cBind.setRequest(bind);
        cBind.setId(Call.callIdGen.incrementAndGet());
        this.out.enQueue(cBind);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        MapClientProxy proxy = new MapClientProxy(this, name);
        proxy.setOutRunnable(this.out);
        return proxy;
    }

    public Transaction getTransaction() {
        TransactionClientProxy proxy = new TransactionClientProxy();
        proxy.setOutRunnable(this.out);
        return proxy;
    }

    public void attachedClusterMemeberConnectionLost() {
        System.out.println("The connection to member : " + this.clusterMembers.get(0) + " is lost");
        this.popAndPush(this.clusterMembers);
        this.connection = this.searchForAvailableConnection();
        this.sendBindRequest(this.connection.getAddress(), this.connection);
        this.reader.setConnection(this.connection);
        this.writer.setConnection(this.connection);
        this.notifyWaitingCalls();
    }

    private void popAndPush(List<InetSocketAddress> clusterMembers) {
        InetSocketAddress address = clusterMembers.remove(0);
        clusterMembers.add(address);
    }

    private Connection searchForAvailableConnection() {
        int counter;
        Connection connection = null;
        for (counter = this.clusterMembers.size(); counter > 0; --counter) {
            try {
                connection = this.getNextConnection();
                break;
            }
            catch (Exception e) {
                this.popAndPush(this.clusterMembers);
                continue;
            }
        }
        if (counter == 0) {
            throw new RuntimeException("No cluster member available to connect");
        }
        System.out.println("Returning connection: " + connection.getAddress());
        return connection;
    }

    private Connection getNextConnection() {
        InetSocketAddress address = this.clusterMembers.get(0);
        Connection connection = new Connection(address);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingCalls() {
        Collection<Call> cc = this.calls.values();
        ArrayList<Call> removed = new ArrayList<Call>();
        removed.addAll(cc);
        for (Call call : removed) {
            this.calls.remove(call.getId());
            Call call2 = call;
            synchronized (call2) {
                call.notify();
            }
        }
    }

    public Connection getCurrentConnection() {
        return this.connection;
    }
}

