/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class DurableExecutorSubmitToPartitionCodec {
    public static final DurableExecutorMessageType REQUEST_TYPE = DurableExecutorMessageType.DURABLEEXECUTOR_SUBMITTOPARTITION;
    public static final int RESPONSE_TYPE = 102;

    public static ClientMessage encodeRequest(String name, Data callable) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, callable);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("DurableExecutor.submitToPartition");
        clientMessage.set(name);
        clientMessage.set(callable);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data callable = null;
        parameters.callable = callable = clientMessage.getData();
        return parameters;
    }

    public static ClientMessage encodeResponse(int response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(102);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        int response = 0;
        parameters.response = response = clientMessage.getInt();
        return parameters;
    }

    public static class ResponseParameters {
        public int response;

        public static int calculateDataSize(int response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += 4;
        }
    }

    public static class RequestParameters {
        public static final DurableExecutorMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data callable;

        public static int calculateDataSize(String name, Data callable) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize((String)name);
            return dataSize += ParameterUtil.calculateDataSize((Data)callable);
        }
    }
}

