/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapFetchNearCacheInvalidationMetadataCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_FETCHNEARCACHEINVALIDATIONMETADATA;
    public static final int RESPONSE_TYPE = 105;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(Collection<String> names, Address address) {
        int requiredDataSize = RequestParameters.calculateDataSize(names, address);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(names.size());
        for (String names_item : names) {
            clientMessage.set(names_item);
        }
        AddressCodec.encode(address, clientMessage);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        ArrayList<String> names = null;
        int names_size = clientMessage.getInt();
        names = new ArrayList<String>(names_size);
        for (int names_index = 0; names_index < names_size; ++names_index) {
            String names_item = null;
            names_item = clientMessage.getStringUtf8();
            names.add(names_item);
        }
        parameters.names = names;
        Address address = null;
        parameters.address = address = AddressCodec.decode(clientMessage);
        return parameters;
    }

    public static ClientMessage encodeResponse(Data response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(105);
        if (response == null) {
            boolean response_isNull = true;
            clientMessage.set(response_isNull);
        } else {
            boolean response_isNull = false;
            clientMessage.set(response_isNull);
            clientMessage.set(response);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        Data response = null;
        boolean response_isNull = clientMessage.getBoolean();
        if (!response_isNull) {
            parameters.response = response = clientMessage.getData();
        }
        return parameters;
    }

    public static class ResponseParameters {
        public Data response;

        public static int calculateDataSize(Data response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            ++dataSize;
            if (response != null) {
                dataSize += ParameterUtil.calculateDataSize((Data)response);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public List<String> names;
        public Address address;

        public static int calculateDataSize(Collection<String> names, Address address) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (String names_item : names) {
                dataSize += ParameterUtil.calculateDataSize((String)names_item);
            }
            return dataSize += AddressCodec.calculateDataSize(address);
        }
    }
}

