/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.RingbufferMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class RingbufferReadManyCodec {
    public static final RingbufferMessageType REQUEST_TYPE = RingbufferMessageType.RINGBUFFER_READMANY;
    public static final int RESPONSE_TYPE = 115;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, long startSequence, int minCount, int maxCount, Data filter) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, startSequence, minCount, maxCount, filter);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(startSequence);
        clientMessage.set(minCount);
        clientMessage.set(maxCount);
        if (filter == null) {
            boolean filter_isNull = true;
            clientMessage.set(filter_isNull);
        } else {
            boolean filter_isNull = false;
            clientMessage.set(filter_isNull);
            clientMessage.set(filter);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        int maxCount;
        int minCount;
        long startSequence;
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        parameters.startSequence = startSequence = clientMessage.getLong();
        parameters.minCount = minCount = clientMessage.getInt();
        parameters.maxCount = maxCount = clientMessage.getInt();
        Data filter = null;
        boolean filter_isNull = clientMessage.getBoolean();
        if (!filter_isNull) {
            parameters.filter = filter = clientMessage.getData();
        }
        return parameters;
    }

    public static ClientMessage encodeResponse(int readCount, Collection<Data> items) {
        int requiredDataSize = ResponseParameters.calculateDataSize(readCount, items);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(115);
        clientMessage.set(readCount);
        clientMessage.set(items.size());
        for (Data items_item : items) {
            clientMessage.set(items_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        int readCount;
        ResponseParameters parameters = new ResponseParameters();
        parameters.readCount = readCount = clientMessage.getInt();
        ArrayList<Data> items = null;
        int items_size = clientMessage.getInt();
        items = new ArrayList<Data>(items_size);
        for (int items_index = 0; items_index < items_size; ++items_index) {
            Data items_item = clientMessage.getData();
            items.add(items_item);
        }
        parameters.items = items;
        return parameters;
    }

    public static class ResponseParameters {
        public int readCount;
        public List<Data> items;

        public static int calculateDataSize(int readCount, Collection<Data> items) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            dataSize += 4;
            for (Data items_item : items) {
                dataSize += ParameterUtil.calculateDataSize((Data)items_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final RingbufferMessageType TYPE = REQUEST_TYPE;
        public String name;
        public long startSequence;
        public int minCount;
        public int maxCount;
        public Data filter;

        public static int calculateDataSize(String name, long startSequence, int minCount, int maxCount, Data filter) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize((String)name);
            dataSize += 8;
            dataSize += 4;
            dataSize += 4;
            ++dataSize;
            if (filter != null) {
                dataSize += ParameterUtil.calculateDataSize((Data)filter);
            }
            return dataSize;
        }
    }
}

