/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TopicAddMessageListenerCodec;
import com.hazelcast.client.impl.protocol.codec.TopicPublishCodec;
import com.hazelcast.client.impl.protocol.codec.TopicRemoveMessageListenerCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerRemoveCodec;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.topic.impl.DataAwareMessage;

public class ClientTopicProxy<E>
extends ClientProxy
implements ITopic<E> {
    private final String name;
    private volatile Data key;

    public ClientTopicProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public void publish(E message) {
        SerializationService serializationService = this.getContext().getSerializationService();
        Data data = serializationService.toData(message);
        ClientMessage request = TopicPublishCodec.encodeRequest((String)this.name, (Data)data);
        this.invoke(request);
    }

    public String addMessageListener(MessageListener<E> listener) {
        ClientMessage request = TopicAddMessageListenerCodec.encodeRequest((String)this.name);
        TopicItemHandler handler = new TopicItemHandler(listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)TopicAddMessageListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, this.getKey(), handler, responseDecoder);
    }

    public boolean removeMessageListener(String registrationId) {
        return this.stopListening(registrationId, new ListenerRemoveCodec(){

            @Override
            public ClientMessage encodeRequest(String realRegistrationId) {
                return TopicRemoveMessageListenerCodec.encodeRequest((String)ClientTopicProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeResponse(ClientMessage clientMessage) {
                return TopicRemoveMessageListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
    }

    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData((Object)this.name);
        }
        return this.key;
    }

    @Override
    protected <T> T invoke(ClientMessage clientMessage) {
        return super.invoke(clientMessage, this.getKey());
    }

    public String toString() {
        return "ITopic{name='" + this.getName() + '\'' + '}';
    }

    private final class TopicItemHandler
    extends TopicAddMessageListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final MessageListener<E> listener;

        private TopicItemHandler(MessageListener<E> listener) {
            this.listener = listener;
        }

        public void handle(Data item, long publishTime, String uuid) {
            SerializationService serializationService = ClientTopicProxy.this.getContext().getSerializationService();
            ClientClusterService clusterService = ClientTopicProxy.this.getContext().getClusterService();
            Member member = clusterService.getMember(uuid);
            DataAwareMessage message = new DataAwareMessage(ClientTopicProxy.this.name, item, publishTime, member, serializationService);
            this.listener.onMessage((Message)message);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

