/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.QueueAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueClearCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToMaxSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.QueueOfferCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePeekCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePollCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePutCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemainingCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueTakeCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerRemoveCodec;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.queue.QueueIterator;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Preconditions;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public final class ClientQueueProxy<E>
extends ClientProxy
implements IQueue<E> {
    private final String name;

    public ClientQueueProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        ClientMessage request = QueueAddListenerCodec.encodeRequest((String)this.name, (boolean)includeValue);
        ItemEventHandler eventHandler = new ItemEventHandler(includeValue, listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, this.getPartitionKey(), eventHandler, responseDecoder);
    }

    public boolean removeItemListener(String registrationId) {
        return this.stopListening(registrationId, new ListenerRemoveCodec(){

            @Override
            public ClientMessage encodeRequest(String realRegistrationId) {
                return QueueRemoveListenerCodec.encodeRequest((String)ClientQueueProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeResponse(ClientMessage clientMessage) {
                return QueueRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
    }

    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full!");
    }

    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void put(E e) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = QueuePutCodec.encodeRequest((String)this.name, (Data)data);
        this.invokeInterruptibly(request);
    }

    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(e, (String)"item can't be null");
        Data data = this.toData(e);
        ClientMessage request = QueueOfferCodec.encodeRequest((String)this.name, (Data)data, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeInterruptibly(request);
        QueueOfferCodec.ResponseParameters resultParameters = QueueOfferCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public E take() throws InterruptedException {
        ClientMessage request = QueueTakeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invokeInterruptibly(request);
        QueueTakeCodec.ResponseParameters resultParameters = QueueTakeCodec.decodeResponse((ClientMessage)response);
        return (E)this.toObject(resultParameters.response);
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = QueuePollCodec.encodeRequest((String)this.name, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeInterruptibly(request);
        QueuePollCodec.ResponseParameters resultParameters = QueuePollCodec.decodeResponse((ClientMessage)response);
        return (E)this.toObject(resultParameters.response);
    }

    public int remainingCapacity() {
        ClientMessage request = QueueRemainingCapacityCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueRemainingCapacityCodec.ResponseParameters resultParameters = QueueRemainingCapacityCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean remove(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueRemoveCodec.encodeRequest((String)this.name, (Data)data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueRemoveCodec.ResponseParameters resultParameters = QueueRemoveCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean contains(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueContainsCodec.encodeRequest((String)this.name, (Data)data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueContainsCodec.ResponseParameters resultParameters = QueueContainsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public int drainTo(Collection<? super E> objects) {
        ClientMessage request = QueueDrainToCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueDrainToCodec.ResponseParameters resultParameters = QueueDrainToCodec.decodeResponse((ClientMessage)response);
        Collection resultCollection = resultParameters.list;
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            objects.add(e);
        }
        return resultCollection.size();
    }

    public int drainTo(Collection<? super E> c, int maxElements) {
        ClientMessage request = QueueDrainToMaxSizeCodec.encodeRequest((String)this.name, (int)maxElements);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueDrainToMaxSizeCodec.ResponseParameters resultParameters = QueueDrainToMaxSizeCodec.decodeResponse((ClientMessage)response);
        Collection resultCollection = resultParameters.list;
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            c.add(e);
        }
        return resultCollection.size();
    }

    public E remove() {
        E res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E element() {
        E res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E peek() {
        ClientMessage request = QueuePeekCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueuePeekCodec.ResponseParameters resultParameters = QueuePeekCodec.decodeResponse((ClientMessage)response);
        return (E)this.toObject(resultParameters.response);
    }

    public int size() {
        ClientMessage request = QueueSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueSizeCodec.ResponseParameters resultParameters = QueueSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean isEmpty() {
        ClientMessage request = QueueIsEmptyCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueIsEmptyCodec.ResponseParameters resultParameters = QueueIsEmptyCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public Iterator<E> iterator() {
        ClientMessage request = QueueIteratorCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse((ClientMessage)response);
        Collection resultCollection = resultParameters.list;
        return new QueueIterator(resultCollection.iterator(), this.getContext().getSerializationService(), false);
    }

    public Object[] toArray() {
        ClientMessage request = QueueIteratorCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse((ClientMessage)response);
        Collection resultCollection = resultParameters.list;
        int i = 0;
        Object[] array = new Object[resultCollection.size()];
        for (Data data : resultCollection) {
            array[i++] = this.toObject(data);
        }
        return array;
    }

    public <T> T[] toArray(T[] ts) {
        ClientMessage request = QueueIteratorCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse((ClientMessage)response);
        Collection resultCollection = resultParameters.list;
        int size = resultCollection.size();
        if (ts.length < size) {
            ts = (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Data data : resultCollection) {
            ts[i++] = this.toObject(data);
        }
        return ts;
    }

    public boolean containsAll(Collection<?> c) {
        ClientMessage request = QueueContainsAllCodec.encodeRequest((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueContainsAllCodec.ResponseParameters resultParameters = QueueContainsAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean addAll(Collection<? extends E> c) {
        ClientMessage request = QueueAddAllCodec.encodeRequest((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueAddAllCodec.ResponseParameters resultParameters = QueueAddAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean removeAll(Collection<?> c) {
        ClientMessage request = QueueCompareAndRemoveAllCodec.encodeRequest((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueCompareAndRemoveAllCodec.ResponseParameters resultParameters = QueueCompareAndRemoveAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean retainAll(Collection<?> c) {
        ClientMessage request = QueueCompareAndRetainAllCodec.encodeRequest((String)this.name, this.getDataList(c));
        ClientMessage response = (ClientMessage)this.invoke(request);
        QueueCompareAndRetainAllCodec.ResponseParameters resultParameters = QueueCompareAndRetainAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void clear() {
        ClientMessage request = QueueClearCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getPartitionKey());
    }

    protected <T> T invokeInterruptibly(ClientMessage req) throws InterruptedException {
        return super.invokeInterruptibly(req, this.getPartitionKey());
    }

    private List<Data> getDataList(Collection<?> objects) {
        ArrayList<Data> dataList = new ArrayList<Data>(objects.size());
        for (Object o : objects) {
            dataList.add(this.toData(o));
        }
        return dataList;
    }

    public String toString() {
        return "IQueue{name='" + this.getName() + '\'' + '}';
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final boolean includeValue;
        private final ItemListener<E> listener;

        public ItemEventHandler(boolean includeValue, ItemListener<E> listener) {
            this.includeValue = includeValue;
            this.listener = listener;
        }

        public void handle(Data dataItem, String uuid, int eventType) {
            SerializationService serializationService = ClientQueueProxy.this.getContext().getSerializationService();
            ClientClusterService clusterService = ClientQueueProxy.this.getContext().getClusterService();
            Member member = clusterService.getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientQueueProxy.this.name, ItemEventType.getByType((int)eventType), dataItem, member, serializationService);
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded((ItemEvent)itemEvent);
            } else {
                this.listener.itemRemoved((ItemEvent)itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

