/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClusterAuthenticator;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationServiceSupport;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Member;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import java.io.IOException;

public final class ClientSmartInvocationServiceImpl
extends ClientInvocationServiceSupport {
    private final LoadBalancer loadBalancer;
    private final ClusterAuthenticator authenticator;

    public ClientSmartInvocationServiceImpl(HazelcastClientInstanceImpl client, LoadBalancer loadBalancer) {
        super(client);
        this.loadBalancer = loadBalancer;
        this.authenticator = new ClusterAuthenticator(client, client.getCredentials());
    }

    @Override
    public void invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) throws IOException {
        Address owner = this.partitionService.getPartitionOwner(partitionId);
        if (owner == null) {
            throw new IOException("Partition does not have owner. partitionId : " + partitionId);
        }
        invocation.getClientMessage().setPartitionId(partitionId);
        Connection connection = this.getConnection(owner);
        this.send(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnRandomTarget(ClientInvocation invocation) throws IOException {
        Address randomAddress = this.getRandomAddress();
        if (randomAddress == null) {
            throw new IOException("Not address found to invoke ");
        }
        Connection connection = this.getConnection(randomAddress);
        this.send(invocation, (ClientConnection)connection);
    }

    @Override
    public void invokeOnTarget(ClientInvocation invocation, Address target) throws IOException {
        if (target == null) {
            throw new NullPointerException("Target can not be null");
        }
        if (!this.isMember(target)) {
            throw new IOException("Target :  " + target + " is not member. ");
        }
        Connection connection = this.getConnection(target);
        this.invokeOnConnection(invocation, (ClientConnection)connection);
    }

    private Connection getConnection(Address target) throws IOException {
        this.ensureOwnerConnectionAvailable();
        return this.connectionManager.getOrTriggerConnect(target, this.authenticator);
    }

    private void ensureOwnerConnectionAvailable() throws IOException {
        boolean isOwnerConnectionAvailable;
        ClientClusterService clientClusterService = this.client.getClientClusterService();
        Address ownerConnectionAddress = clientClusterService.getOwnerConnectionAddress();
        boolean bl = isOwnerConnectionAvailable = ownerConnectionAddress != null && this.connectionManager.getConnection(ownerConnectionAddress) != null;
        if (!isOwnerConnectionAvailable) {
            if (this.isShutdown()) {
                throw new HazelcastException("ConnectionManager is not active!");
            }
            throw new IOException("Not able to setup owner connection!");
        }
    }

    @Override
    public void invokeOnConnection(ClientInvocation invocation, ClientConnection connection) throws IOException {
        this.send(invocation, connection);
    }

    private Address getRandomAddress() {
        Member member = this.loadBalancer.next();
        if (member != null) {
            return ((AbstractMember)member).getAddress();
        }
        return null;
    }

    private boolean isMember(Address target) {
        Member member = this.client.getClientClusterService().getMember(target);
        return member != null;
    }
}

