/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientInvocationFuture
implements ICompletableFuture<ClientMessage> {
    protected static final ILogger LOGGER = Logger.getLogger(ClientInvocationFuture.class);
    protected final ClientMessage clientMessage;
    protected volatile Object response;
    private final ClientExecutionServiceImpl executionService;
    private final List<ExecutionCallbackNode> callbackNodeList = new LinkedList<ExecutionCallbackNode>();
    private final ClientInvocation invocation;

    public ClientInvocationFuture(ClientInvocation invocation, HazelcastClientInstanceImpl client, ClientMessage clientMessage) {
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.clientMessage = clientMessage;
        this.invocation = invocation;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return this.response != null;
    }

    public ClientMessage get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException exception) {
            throw ExceptionUtil.rethrow((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientMessage get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long waitMillis;
        int heartBeatInterval = this.invocation.getHeartBeatInterval();
        if (this.response == null && (waitMillis = unit.toMillis(timeout)) > 0L) {
            ClientInvocationFuture clientInvocationFuture = this;
            synchronized (clientInvocationFuture) {
                while (waitMillis > 0L && this.response == null) {
                    long start = Clock.currentTimeMillis();
                    this.wait(Math.min((long)heartBeatInterval, waitMillis));
                    long elapsed = Clock.currentTimeMillis() - start;
                    waitMillis -= elapsed;
                    if (this.invocation.isConnectionHealthy(elapsed)) continue;
                    this.invocation.notifyException((Throwable)new TargetDisconnectedException());
                }
            }
        }
        return this.resolveResponse();
    }

    boolean shouldSetResponse(Object response) {
        if (this.response != null) {
            LOGGER.warning("The Future.set() method can only be called once. Request: " + this.clientMessage + ", current response: " + this.response + ", new response: " + response);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResponse(Object response) {
        ClientInvocationFuture clientInvocationFuture = this;
        synchronized (clientInvocationFuture) {
            if (!this.shouldSetResponse(response)) {
                return;
            }
            this.response = response;
            this.notifyAll();
            for (ExecutionCallbackNode node : this.callbackNodeList) {
                this.runAsynchronous(node.callback, node.executor);
            }
            this.callbackNodeList.clear();
        }
    }

    private ClientMessage resolveResponse() throws ExecutionException, TimeoutException, InterruptedException {
        if (this.response instanceof Throwable) {
            ExceptionUtil.fixRemoteStackTrace((Throwable)((Throwable)this.response), (StackTraceElement[])Thread.currentThread().getStackTrace());
            if (this.response instanceof ExecutionException) {
                throw (ExecutionException)this.response;
            }
            if (this.response instanceof TimeoutException) {
                throw (TimeoutException)this.response;
            }
            if (this.response instanceof Error) {
                throw (Error)this.response;
            }
            if (this.response instanceof InterruptedException) {
                throw (InterruptedException)this.response;
            }
            throw new ExecutionException((Throwable)this.response);
        }
        if (this.response == null) {
            throw new TimeoutException();
        }
        return (ClientMessage)this.response;
    }

    public void andThen(ExecutionCallback<ClientMessage> callback) {
        this.andThen(callback, this.executionService.getAsyncExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void andThen(ExecutionCallback<ClientMessage> callback, Executor executor) {
        ClientInvocationFuture clientInvocationFuture = this;
        synchronized (clientInvocationFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor);
                return;
            }
            this.callbackNodeList.add(new ExecutionCallbackNode(callback, executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void andThenInternal(ExecutionCallback<ClientMessage> callback) {
        ExecutorService executor = this.executionService.getAsyncExecutor();
        ClientInvocationFuture clientInvocationFuture = this;
        synchronized (clientInvocationFuture) {
            if (this.response != null) {
                this.runAsynchronous(callback, executor);
                return;
            }
            this.callbackNodeList.add(new ExecutionCallbackNode(callback, executor));
        }
    }

    private void runAsynchronous(final ExecutionCallback callback, Executor executor) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientMessage resp;
                        try {
                            resp = ClientInvocationFuture.this.resolveResponse();
                        }
                        catch (Throwable t) {
                            callback.onFailure(t);
                            return;
                        }
                        callback.onResponse((Object)resp);
                    }
                    catch (Throwable t) {
                        LOGGER.severe("Failed to execute callback: " + callback + "! Request: " + ClientInvocationFuture.this.clientMessage + ", response: " + ClientInvocationFuture.this.response, t);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOGGER.warning("Execution of callback: " + callback + " is rejected!", (Throwable)e);
        }
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }

    static class ExecutionCallbackNode {
        final ExecutionCallback callback;
        final Executor executor;

        ExecutionCallbackNode(ExecutionCallback callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }
    }
}

