/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.LockForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.LockGetLockCountCodec;
import com.hazelcast.client.impl.protocol.codec.LockGetRemainingLeaseTimeCodec;
import com.hazelcast.client.impl.protocol.codec.LockIsLockedByCurrentThreadCodec;
import com.hazelcast.client.impl.protocol.codec.LockIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.LockLockCodec;
import com.hazelcast.client.impl.protocol.codec.LockTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.LockUnlockCodec;
import com.hazelcast.client.proxy.ClientConditionProxy;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ClientLockProxy
extends ClientProxy
implements ILock {
    private volatile Data key;

    public ClientLockProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    @Deprecated
    public Object getKey() {
        return this.getName();
    }

    public boolean isLocked() {
        ClientMessage request = LockIsLockedCodec.encodeRequest((String)this.getName());
        LockIsLockedCodec.ResponseParameters resultParameters = LockIsLockedCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    public boolean isLockedByCurrentThread() {
        ClientMessage request = LockIsLockedByCurrentThreadCodec.encodeRequest((String)this.getName(), (long)ThreadUtil.getThreadId());
        LockIsLockedByCurrentThreadCodec.ResponseParameters resultParameters = LockIsLockedByCurrentThreadCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    public int getLockCount() {
        ClientMessage request = LockGetLockCountCodec.encodeRequest((String)this.getName());
        LockGetLockCountCodec.ResponseParameters resultParameters = LockGetLockCountCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    public long getRemainingLeaseTime() {
        ClientMessage request = LockGetRemainingLeaseTimeCodec.encodeRequest((String)this.getName());
        LockGetRemainingLeaseTimeCodec.ResponseParameters resultParameters = LockGetRemainingLeaseTimeCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    public void lock(long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkPositive((long)leaseTime, (String)"leaseTime should be positive");
        ClientMessage request = LockLockCodec.encodeRequest((String)this.getName(), (long)this.getTimeInMillis(leaseTime, timeUnit), (long)ThreadUtil.getThreadId());
        this.invoke(request);
    }

    public void forceUnlock() {
        ClientMessage request = LockForceUnlockCodec.encodeRequest((String)this.getName());
        this.invoke(request);
    }

    public ICondition newCondition(String name) {
        return new ClientConditionProxy(this, name, this.getContext());
    }

    public void lock() {
        ClientMessage request = LockLockCodec.encodeRequest((String)this.getName(), (long)-1L, (long)ThreadUtil.getThreadId());
        this.invoke(request);
    }

    public void lockInterruptibly() throws InterruptedException {
        ClientMessage request = LockLockCodec.encodeRequest((String)this.getName(), (long)-1L, (long)ThreadUtil.getThreadId());
        this.invokeInterruptibly(request, this.getKeyData());
    }

    public boolean tryLock() {
        try {
            return this.tryLock(0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        ClientMessage request = LockTryLockCodec.encodeRequest((String)this.getName(), (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(time, unit));
        LockTryLockCodec.ResponseParameters resultParameters = LockTryLockCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    public void unlock() {
        ClientMessage request = LockUnlockCodec.encodeRequest((String)this.getName(), (long)ThreadUtil.getThreadId());
        this.invoke(request);
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private Data getKeyData() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKeyData());
    }

    public String toString() {
        return "ILock{name='" + this.getName() + '\'' + '}';
    }
}

