/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientMembershipListenerCodec;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientListenerInvocation;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class ClientMembershipListener
extends ClientMembershipListenerCodec.AbstractEventHandler
implements EventHandler<ClientMessage> {
    public static final int INITIAL_MEMBERS_TIMEOUT_SECONDS = 5;
    private static final ILogger LOGGER = Logger.getLogger(ClientMembershipListener.class);
    private final List<Member> members = new LinkedList<Member>();
    private final HazelcastClientInstanceImpl client;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientConnectionManagerImpl connectionManager;
    private volatile CountDownLatch initialListFetchedLatch;

    public ClientMembershipListener(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.partitionService = (ClientPartitionServiceImpl)client.getClientPartitionService();
        this.clusterService = (ClientClusterServiceImpl)client.getClientClusterService();
    }

    public void handle(Member member, int eventType) {
        switch (eventType) {
            case 1: {
                this.memberAdded(member);
                break;
            }
            case 2: {
                this.memberRemoved(member);
                break;
            }
            default: {
                LOGGER.warning("Unknown event type :" + eventType);
            }
        }
        this.partitionService.refreshPartitions();
    }

    @Override
    public void handle(Collection<Member> initialMembers) {
        Map<String, Member> prevMembers = Collections.emptyMap();
        if (!this.members.isEmpty()) {
            prevMembers = new HashMap(this.members.size());
            for (Member member : this.members) {
                prevMembers.put(member.getUuid(), member);
            }
            this.members.clear();
        }
        for (Member initialMember : initialMembers) {
            this.members.add(initialMember);
        }
        List<MembershipEvent> events = this.detectMembershipEvents(prevMembers);
        if (events.size() != 0) {
            this.applyMemberListChanges();
        }
        this.fireMembershipEvent(events);
        this.initialListFetchedLatch.countDown();
    }

    @Override
    public void handle(MemberAttributeChange memberAttributeChange) {
        Map<Address, Member> memberMap = this.clusterService.getMembersRef();
        if (memberMap == null) {
            return;
        }
        if (memberAttributeChange == null) {
            return;
        }
        for (Member target : memberMap.values()) {
            if (!target.getUuid().equals(memberAttributeChange.getUuid())) continue;
            MemberAttributeOperationType operationType = memberAttributeChange.getOperationType();
            String key = memberAttributeChange.getKey();
            Object value = memberAttributeChange.getValue();
            ((AbstractMember)target).updateAttribute(operationType, key, value);
            MemberAttributeEvent memberAttributeEvent = new MemberAttributeEvent(this.client.getCluster(), target, operationType, key, value);
            this.clusterService.fireMemberAttributeEvent(memberAttributeEvent);
            break;
        }
    }

    @Override
    public void beforeListenerRegister() {
    }

    @Override
    public void onListenerRegister() {
    }

    void listenMembershipEvents(Address ownerConnectionAddress) {
        block4: {
            this.initialListFetchedLatch = new CountDownLatch(1);
            try {
                ClientMessage clientMessage = ClientMembershipListenerCodec.encodeRequest();
                ClientConnection connection = this.connectionManager.getConnection(ownerConnectionAddress);
                if (connection == null) {
                    throw new IllegalStateException("Can not load initial members list because owner connection is null. Address " + ownerConnectionAddress);
                }
                ClientListenerInvocation invocation = new ClientListenerInvocation(this.client, (EventHandler)this, clientMessage, connection, new ClientMessageDecoder(){

                    @Override
                    public <T> T decodeClientMessage(ClientMessage clientMessage) {
                        return (T)ClientMembershipListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                    }
                });
                invocation.invoke().get();
                this.waitInitialMemberListFetched();
            }
            catch (Exception e) {
                if (!this.client.getLifecycleService().isRunning()) break block4;
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.warning("Error while registering to cluster events! -> " + ownerConnectionAddress, (Throwable)e);
                }
                LOGGER.warning("Error while registering to cluster events! -> " + ownerConnectionAddress + ", Error: " + e.toString());
            }
        }
    }

    private void waitInitialMemberListFetched() throws InterruptedException {
        boolean success = this.initialListFetchedLatch.await(5L, TimeUnit.SECONDS);
        if (!success) {
            LOGGER.warning("Error while getting initial member list from cluster!");
        }
    }

    private void memberRemoved(Member member) {
        this.members.remove(member);
        ClientConnection connection = this.connectionManager.getConnection(((AbstractMember)member).getAddress());
        if (connection != null) {
            this.connectionManager.destroyConnection(connection);
        }
        this.applyMemberListChanges();
        MembershipEvent event = new MembershipEvent(this.client.getCluster(), member, 2, Collections.unmodifiableSet(new LinkedHashSet<Member>(this.members)));
        this.clusterService.fireMembershipEvent(event);
    }

    private void applyMemberListChanges() {
        this.updateMembersRef();
        LOGGER.info(this.clusterService.membersString());
    }

    private void fireMembershipEvent(List<MembershipEvent> events) {
        for (MembershipEvent event : events) {
            this.clusterService.fireMembershipEvent(event);
        }
    }

    private List<MembershipEvent> detectMembershipEvents(Map<String, Member> prevMembers) {
        LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
        Set<Member> eventMembers = Collections.unmodifiableSet(new LinkedHashSet<Member>(this.members));
        for (Member member : this.members) {
            Member former = prevMembers.remove(member.getUuid());
            if (former != null) continue;
            events.add(new MembershipEvent(this.client.getCluster(), member, 1, eventMembers));
        }
        for (Member member : prevMembers.values()) {
            ClientConnection connection;
            events.add(new MembershipEvent(this.client.getCluster(), member, 2, eventMembers));
            Address address = ((AbstractMember)member).getAddress();
            if (this.clusterService.getMember(address) != null || (connection = this.connectionManager.getConnection(address)) == null) continue;
            this.connectionManager.destroyConnection(connection);
        }
        return events;
    }

    private void memberAdded(Member member) {
        this.members.add(member);
        this.applyMemberListChanges();
        MembershipEvent event = new MembershipEvent(this.client.getCluster(), member, 1, Collections.unmodifiableSet(new LinkedHashSet<Member>(this.members)));
        this.clusterService.fireMembershipEvent(event);
    }

    private void updateMembersRef() {
        LinkedHashMap<Address, Member> map = new LinkedHashMap<Address, Member>(this.members.size());
        for (Member member : this.members) {
            map.put(((AbstractMember)member).getAddress(), member);
        }
        this.clusterService.setMembersRef(Collections.unmodifiableMap(map));
    }
}

