/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ConditionAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.ConditionBeforeAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.ConditionSignalAllCodec;
import com.hazelcast.client.impl.protocol.codec.ConditionSignalCodec;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.lock.InternalLockNamespace;
import com.hazelcast.core.ICondition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ClientConditionProxy
extends ClientProxy
implements ICondition {
    private final String conditionId;
    private final ClientLockProxy lockProxy;
    private volatile Data key;
    private final InternalLockNamespace namespace;

    public ClientConditionProxy(ClientLockProxy clientLockProxy, String name, ClientContext ctx) {
        super("hz:impl:lockService", clientLockProxy.getName());
        this.setContext(ctx);
        this.lockProxy = clientLockProxy;
        this.namespace = new InternalLockNamespace(this.lockProxy.getName());
        this.conditionId = name;
        this.key = this.toData(this.lockProxy.getName());
    }

    public void await() throws InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public void awaitUninterruptibly() {
        try {
            this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        long start = System.nanoTime();
        this.await(nanosTimeout, TimeUnit.NANOSECONDS);
        long end = System.nanoTime();
        return nanosTimeout - (end - start);
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long threadId = ThreadUtil.getThreadId();
        this.beforeAwait(threadId);
        return this.doAwait(time, unit, threadId);
    }

    private void beforeAwait(long threadId) {
        ClientMessage request = ConditionBeforeAwaitCodec.encodeRequest((String)this.conditionId, (long)threadId, (String)this.lockProxy.getName());
        this.invoke(request);
    }

    private boolean doAwait(long time, TimeUnit unit, long threadId) throws InterruptedException {
        long timeoutInMillis = unit.toMillis(time);
        ClientMessage request = ConditionAwaitCodec.encodeRequest((String)this.conditionId, (long)threadId, (long)timeoutInMillis, (String)this.lockProxy.getName());
        ClientMessage response = (ClientMessage)this.invoke(request);
        return ConditionAwaitCodec.decodeResponse((ClientMessage)response).response;
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        long until = deadline.getTime();
        long timeToDeadline = until - Clock.currentTimeMillis();
        return this.await(timeToDeadline, TimeUnit.MILLISECONDS);
    }

    public void signal() {
        ClientMessage request = ConditionSignalCodec.encodeRequest((String)this.conditionId, (long)ThreadUtil.getThreadId(), (String)this.lockProxy.getName());
        this.invoke(request);
    }

    public void signalAll() {
        ClientMessage request = ConditionSignalAllCodec.encodeRequest((String)this.conditionId, (long)ThreadUtil.getThreadId(), (String)this.lockProxy.getName());
        this.invoke(request);
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.key);
    }
}

