/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.map.impl.nearcache.ClientHeapNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapAddEntryListenerRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapAddNearCacheListenerRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapClearRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapContainsKeyRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapContainsValueRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapEntrySetRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapGetRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapIsEmptyRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapKeySetRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapPutAllRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapPutTtlRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapRemoveEntryListenerRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapRemoveRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapSizeRequest;
import com.hazelcast.replicatedmap.impl.client.ClientReplicatedMapValuesRequest;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapEntries;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapKeys;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableEntryEvent;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapValueCollection;
import com.hazelcast.replicatedmap.impl.record.ResultSet;
import com.hazelcast.util.IterationType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class ClientReplicatedMapProxy<K, V>
extends ClientProxy
implements ReplicatedMap<K, V> {
    private static final Random RANDOM_PARTITION_ID_GENERATOR = new Random();
    private static final AtomicIntegerFieldUpdater<ClientReplicatedMapProxy> TARGET_PARTITION_ID_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientReplicatedMapProxy.class, "targetPartitionId");
    private volatile NearCache nearCache;
    private volatile String invalidationListenerId;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();
    private volatile int targetPartitionId = -1;

    public ClientReplicatedMapProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onDestroy() {
        if (this.nearCache != null) {
            this.removeNearCacheInvalidationListener();
            this.nearCache.destroy();
        }
    }

    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        Data dataKey = this.toData(key);
        Data dataValue = this.toData(value);
        ClientReplicatedMapPutTtlRequest request = new ClientReplicatedMapPutTtlRequest(this.getName(), dataKey, dataValue, timeUnit.toMillis(ttl));
        return (V)this.invoke((ClientRequest)request, dataKey);
    }

    public int size() {
        ClientReplicatedMapSizeRequest request = new ClientReplicatedMapSizeRequest(this.getName(), this.getOrInitTargetPartitionId());
        return (Integer)this.invokeOnPartition((ClientRequest)request, this.getOrInitTargetPartitionId());
    }

    public boolean isEmpty() {
        ClientReplicatedMapIsEmptyRequest request = new ClientReplicatedMapIsEmptyRequest(this.getName(), this.getOrInitTargetPartitionId());
        return (Boolean)this.invokeOnPartition((ClientRequest)request, this.getOrInitTargetPartitionId());
    }

    public boolean containsKey(Object key) {
        Data dataKey = this.toData(key);
        return (Boolean)this.invoke((ClientRequest)new ClientReplicatedMapContainsKeyRequest(this.getName(), dataKey), dataKey);
    }

    public boolean containsValue(Object value) {
        Data dataValue = this.toData(value);
        ClientReplicatedMapContainsValueRequest request = new ClientReplicatedMapContainsValueRequest(this.getName(), dataValue, this.getOrInitTargetPartitionId());
        return (Boolean)this.invokeOnPartition((ClientRequest)request, this.getOrInitTargetPartitionId());
    }

    public V get(Object key) {
        Object value;
        Object cached;
        this.initNearCache();
        if (this.nearCache != null && (cached = this.nearCache.get(key)) != null) {
            if (cached.equals(NearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        Data dataKey = this.toData(key);
        ClientReplicatedMapGetRequest request = new ClientReplicatedMapGetRequest(this.getName(), dataKey);
        Object response = this.invoke((ClientRequest)request, dataKey);
        Object object = value = response != null ? response : null;
        if (this.nearCache != null) {
            this.nearCache.put(key, value);
        }
        return (V)value;
    }

    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    public V remove(Object key) {
        Data dataKey = this.toData(key);
        ClientReplicatedMapRemoveRequest request = new ClientReplicatedMapRemoveRequest(this.getName(), dataKey);
        return (V)this.invoke((ClientRequest)request, dataKey);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        Set<Map.Entry<K, V>> entries = m.entrySet();
        ArrayList<AbstractMap.SimpleImmutableEntry<Data, Data>> dataEntries = new ArrayList<AbstractMap.SimpleImmutableEntry<Data, Data>>(m.size());
        for (Map.Entry<K, V> entry : entries) {
            dataEntries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(this.toData(entry.getKey()), this.toData(entry.getValue())));
        }
        ReplicatedMapEntries entrySet = new ReplicatedMapEntries(dataEntries);
        ClientReplicatedMapPutAllRequest req = new ClientReplicatedMapPutAllRequest(this.getName(), entrySet);
        this.invoke((ClientRequest)req);
    }

    public void clear() {
        ClientReplicatedMapClearRequest request = new ClientReplicatedMapClearRequest(this.getName());
        this.invoke((ClientRequest)request);
    }

    public boolean removeEntryListener(String id) {
        return this.deregisterListener(id);
    }

    public String addEntryListener(EntryListener<K, V> listener) {
        ClientReplicatedMapAddEntryListenerRequest addRequest = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), null, null);
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        ClientReplicatedMapRemoveEntryListenerRequest removeRequest = new ClientReplicatedMapRemoveEntryListenerRequest(this.getName());
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key) {
        Data dataKey = this.toData(key);
        ClientReplicatedMapAddEntryListenerRequest addRequest = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), null, dataKey);
        ClientReplicatedMapRemoveEntryListenerRequest removeRequest = new ClientReplicatedMapRemoveEntryListenerRequest(this.getName());
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        ClientReplicatedMapAddEntryListenerRequest addRequest = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), predicate, null);
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        ClientReplicatedMapRemoveEntryListenerRequest removeRequest = new ClientReplicatedMapRemoveEntryListenerRequest(this.getName());
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        Data dataKey = this.toData(key);
        ClientReplicatedMapAddEntryListenerRequest addRequest = new ClientReplicatedMapAddEntryListenerRequest(this.getName(), predicate, dataKey);
        EventHandler<ReplicatedMapPortableEntryEvent> handler = this.createHandler(listener);
        ClientReplicatedMapRemoveEntryListenerRequest removeRequest = new ClientReplicatedMapRemoveEntryListenerRequest(this.getName());
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
    }

    public Set<K> keySet() {
        ClientReplicatedMapKeySetRequest request = new ClientReplicatedMapKeySetRequest(this.getName(), this.getOrInitTargetPartitionId());
        ReplicatedMapKeys response = (ReplicatedMapKeys)this.invokeOnPartition((ClientRequest)request, this.getOrInitTargetPartitionId());
        List dataKeys = response.getKeys();
        ArrayList keys = new ArrayList(dataKeys.size());
        for (Data dataKey : dataKeys) {
            keys.add(new AbstractMap.SimpleImmutableEntry(this.toObject(dataKey), null));
        }
        return new ResultSet(keys, IterationType.KEY);
    }

    public LocalReplicatedMapStats getReplicatedMapStats() {
        throw new UnsupportedOperationException("Replicated Map statistics are not available for client !");
    }

    public Collection<V> values() {
        ClientReplicatedMapValuesRequest request = new ClientReplicatedMapValuesRequest(this.getName(), this.getOrInitTargetPartitionId());
        ReplicatedMapValueCollection result = (ReplicatedMapValueCollection)this.invokeOnPartition((ClientRequest)request, this.getOrInitTargetPartitionId());
        Collection dataValues = result.getValues();
        ArrayList values = new ArrayList(dataValues.size());
        for (Data dataValue : dataValues) {
            values.add(this.toObject(dataValue));
        }
        return values;
    }

    public Collection<V> values(Comparator<V> comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientReplicatedMapEntrySetRequest request = new ClientReplicatedMapEntrySetRequest(this.getName(), this.getOrInitTargetPartitionId());
        ReplicatedMapEntries response = (ReplicatedMapEntries)this.invokeOnPartition((ClientRequest)request, this.getOrInitTargetPartitionId());
        List dataEntries = response.getEntries();
        ArrayList entries = new ArrayList(dataEntries.size());
        for (Map.Entry dataEntry : dataEntries) {
            Object key = this.toObject(dataEntry.getKey());
            Object value = this.toObject(dataEntry.getValue());
            entries.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return new ResultSet(entries, IterationType.ENTRY);
    }

    private EventHandler<ReplicatedMapPortableEntryEvent> createHandler(EntryListener<K, V> listener) {
        return new ReplicatedMapEventHandler(listener);
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            ClientHeapNearCache nearCache;
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.getName());
            if (nearCacheConfig == null) {
                return;
            }
            this.nearCache = nearCache = new ClientHeapNearCache(this.getName(), this.getContext(), nearCacheConfig);
            if (nearCache.isInvalidateOnChange()) {
                this.addNearCacheInvalidateListener();
            }
        }
    }

    private void addNearCacheInvalidateListener() {
        try {
            ClientReplicatedMapAddNearCacheListenerRequest addRequest = new ClientReplicatedMapAddNearCacheListenerRequest(this.getName());
            ClientReplicatedMapRemoveEntryListenerRequest removeRequest = new ClientReplicatedMapRemoveEntryListenerRequest(this.getName());
            ReplicatedMapNearCacheEventHandler handler = new ReplicatedMapNearCacheEventHandler();
            this.invalidationListenerId = this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, handler);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.invalidationListenerId != null) {
            this.deregisterListener(this.invalidationListenerId);
        }
    }

    public String toString() {
        return "ReplicatedMap{name='" + this.getName() + '\'' + '}';
    }

    private void invalidateNearCache() {
        if (this.nearCache != null) {
            this.nearCache.clear();
        }
    }

    private int getOrInitTargetPartitionId() {
        int targetPartitionId = this.targetPartitionId;
        while (targetPartitionId == -1) {
            int partitionCount = this.getContext().getPartitionService().getPartitionCount();
            targetPartitionId = RANDOM_PARTITION_ID_GENERATOR.nextInt(partitionCount);
            if (TARGET_PARTITION_ID_UPDATER.compareAndSet(this, -1, targetPartitionId)) continue;
            targetPartitionId = this.targetPartitionId;
        }
        return targetPartitionId;
    }

    private class ReplicatedMapNearCacheEventHandler
    implements EventHandler<ReplicatedMapPortableEntryEvent> {
        private ReplicatedMapNearCacheEventHandler() {
        }

        @Override
        public void handle(ReplicatedMapPortableEntryEvent event) {
            switch (event.getEventType()) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: {
                    ClientReplicatedMapProxy.this.nearCache.remove(ClientReplicatedMapProxy.this.toObject(event.getKey()));
                    break;
                }
                case CLEAR_ALL: {
                    ClientReplicatedMapProxy.this.nearCache.clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + event.getEventType());
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
            ClientReplicatedMapProxy.this.invalidateNearCache();
        }

        @Override
        public void onListenerRegister() {
            ClientReplicatedMapProxy.this.invalidateNearCache();
        }
    }

    private class ReplicatedMapEventHandler
    implements EventHandler<ReplicatedMapPortableEntryEvent> {
        private final EntryListener<K, V> listener;

        ReplicatedMapEventHandler(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        @Override
        public void handle(ReplicatedMapPortableEntryEvent event) {
            EntryEventType eventType = event.getEventType();
            Data keyData = event.getKey();
            Data valueData = event.getValue();
            Data oldValueData = event.getOldValue();
            Member member = ClientReplicatedMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
            int type = eventType.getType();
            DataAwareEntryEvent entryEvent = new DataAwareEntryEvent(member, type, ClientReplicatedMapProxy.this.getName(), keyData, valueData, oldValueData, null, ClientReplicatedMapProxy.this.getContext().getSerializationService());
            switch (event.getEventType()) {
                case ADDED: {
                    this.listener.entryAdded((EntryEvent)entryEvent);
                    break;
                }
                case REMOVED: {
                    this.listener.entryRemoved((EntryEvent)entryEvent);
                    break;
                }
                case UPDATED: {
                    this.listener.entryUpdated((EntryEvent)entryEvent);
                    break;
                }
                case EVICTED: {
                    this.listener.entryEvicted((EntryEvent)entryEvent);
                    break;
                }
                case CLEAR_ALL: {
                    MapEvent mapEvent = new MapEvent((Object)ClientReplicatedMapProxy.this.getName(), member, EntryEventType.CLEAR_ALL.getType(), event.getNumberOfAffectedEntries());
                    this.listener.mapCleared(mapEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + event.getEventType());
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

