/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.Logger;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobProcessInformation;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.TrackableJob;
import com.hazelcast.mapreduce.impl.AbstractJob;
import com.hazelcast.mapreduce.impl.client.ClientCancellationRequest;
import com.hazelcast.mapreduce.impl.client.ClientJobProcessInformationRequest;
import com.hazelcast.mapreduce.impl.client.ClientMapReduceRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.UuidUtil;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

public class ClientMapReduceProxy
extends ClientProxy
implements JobTracker {
    private final ConcurrentMap<String, ClientTrackableJob> trackableJobs = new ConcurrentHashMap<String, ClientTrackableJob>();

    public ClientMapReduceProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onDestroy() {
        for (ClientTrackableJob trackableJob : this.trackableJobs.values()) {
            trackableJob.completableFuture.cancel(false);
        }
    }

    public <K, V> Job<K, V> newJob(KeyValueSource<K, V> source) {
        return new ClientJob<K, V>(this.getName(), source);
    }

    public <V> TrackableJob<V> getTrackableJob(String jobId) {
        return (TrackableJob)this.trackableJobs.get(jobId);
    }

    public String toString() {
        return "JobTracker{name='" + this.getName() + '\'' + '}';
    }

    private <T> T invoke(InvocationClientRequest request, String jobId) throws Exception {
        ClientTrackableJob trackableJob = (ClientTrackableJob)this.trackableJobs.get(jobId);
        if (trackableJob != null) {
            ClientConnection sendConnection = trackableJob.clientInvocation.getSendConnection();
            Address runningMember = sendConnection.getEndPoint();
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), (ClientRequest)request, runningMember);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (T)future.get();
        }
        return null;
    }

    private final class ClientTrackableJob<V>
    implements TrackableJob<V> {
        private final String jobId;
        private final ClientInvocation clientInvocation;
        private final AbstractCompletableFuture<V> completableFuture;

        private ClientTrackableJob(String jobId, ClientInvocation clientInvocation, AbstractCompletableFuture<V> completableFuture) {
            this.jobId = jobId;
            this.clientInvocation = clientInvocation;
            this.completableFuture = completableFuture;
        }

        public JobTracker getJobTracker() {
            return ClientMapReduceProxy.this;
        }

        public String getName() {
            return ClientMapReduceProxy.this.getName();
        }

        public String getJobId() {
            return this.jobId;
        }

        public ICompletableFuture<V> getCompletableFuture() {
            return this.completableFuture;
        }

        public JobProcessInformation getJobProcessInformation() {
            try {
                return (JobProcessInformation)ClientMapReduceProxy.this.invoke((InvocationClientRequest)new ClientJobProcessInformationRequest(this.getName(), this.jobId), this.jobId);
            }
            catch (Exception ignore) {
                EmptyStatement.ignore((Throwable)ignore);
                return null;
            }
        }
    }

    private class ClientCompletableFuture<V>
    extends AbstractCompletableFuture<V>
    implements JobCompletableFuture<V> {
        private final String jobId;

        protected ClientCompletableFuture(String jobId) {
            super((Executor)ClientMapReduceProxy.this.getContext().getExecutionService().getAsyncExecutor(), Logger.getLogger(ClientCompletableFuture.class));
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        protected boolean shouldCancel(boolean mayInterruptIfRunning) {
            boolean cancelled = false;
            try {
                cancelled = (Boolean)ClientMapReduceProxy.this.invoke((InvocationClientRequest)new ClientCancellationRequest(ClientMapReduceProxy.this.getName(), this.jobId), this.jobId);
            }
            catch (Exception ignore) {
                EmptyStatement.ignore((Throwable)ignore);
            }
            return cancelled;
        }

        protected void setResult(Object result) {
            super.setResult(result);
        }
    }

    private class ClientJob<KeyIn, ValueIn>
    extends AbstractJob<KeyIn, ValueIn> {
        public ClientJob(String name, KeyValueSource<KeyIn, ValueIn> keyValueSource) {
            super(name, (JobTracker)ClientMapReduceProxy.this, keyValueSource);
        }

        protected <T> JobCompletableFuture<T> invoke(final Collator collator) {
            try {
                final String jobId = UuidUtil.newUnsecureUuidString();
                ClientMapReduceRequest request = new ClientMapReduceRequest(this.name, jobId, this.keys, this.predicate, this.mapper, this.combinerFactory, this.reducerFactory, this.keyValueSource, this.chunkSize, this.topologyChangedStrategy);
                final ClientCompletableFuture completableFuture = new ClientCompletableFuture(jobId);
                ClientInvocation clientInvocation = new ClientInvocation(ClientMapReduceProxy.this.getClient(), (ClientRequest)request);
                ClientInvocationFuture future = clientInvocation.invoke();
                future.andThen(new ExecutionCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Object res) {
                        Object response = res;
                        try {
                            if (collator != null) {
                                response = collator.collate(((Map)response).entrySet());
                            }
                        }
                        finally {
                            completableFuture.setResult(response);
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFailure(Throwable throwable) {
                        Throwable t = throwable;
                        try {
                            if (t instanceof ExecutionException && t.getCause() instanceof CancellationException) {
                                t = t.getCause();
                            }
                            completableFuture.setResult(t);
                        }
                        finally {
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }
                });
                ClientMapReduceProxy.this.trackableJobs.putIfAbsent(jobId, new ClientTrackableJob(jobId, clientInvocation, completableFuture));
                return completableFuture;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

