/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.client.BaseTransactionRequest;
import com.hazelcast.transaction.client.CommitTransactionRequest;
import com.hazelcast.transaction.client.CreateTransactionRequest;
import com.hazelcast.transaction.client.RollbackTransactionRequest;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;

final class TransactionProxy {
    private static final ThreadLocal<Boolean> TRANSACTION_EXISTS = new ThreadLocal();
    private final TransactionOptions options;
    private final HazelcastClientInstanceImpl client;
    private final long threadId = Thread.currentThread().getId();
    private final ClientConnection connection;
    private String txnId;
    private Transaction.State state = Transaction.State.NO_TXN;
    private long startTime;

    TransactionProxy(HazelcastClientInstanceImpl client, TransactionOptions options, ClientConnection connection) {
        this.options = options;
        this.client = client;
        this.connection = connection;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Transaction.State getState() {
        return this.state;
    }

    void begin() {
        try {
            if (this.state == Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is already active");
            }
            this.checkThread();
            if (TRANSACTION_EXISTS.get() != null) {
                throw new IllegalStateException("Nested transactions are not allowed!");
            }
            TRANSACTION_EXISTS.set(Boolean.TRUE);
            this.startTime = Clock.currentTimeMillis();
            this.txnId = (String)this.invoke((ClientRequest)new CreateTransactionRequest(this.options));
            this.state = Transaction.State.ACTIVE;
        }
        catch (Exception e) {
            TRANSACTION_EXISTS.set(null);
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    void commit() {
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            this.checkThread();
            this.checkTimeout();
            this.invoke((ClientRequest)new CommitTransactionRequest());
            this.state = Transaction.State.COMMITTED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            TRANSACTION_EXISTS.set(null);
        }
    }

    void rollback() {
        try {
            if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
                throw new IllegalStateException("Transaction is not active");
            }
            if (this.state == Transaction.State.ROLLING_BACK) {
                this.state = Transaction.State.ROLLED_BACK;
                return;
            }
            this.checkThread();
            try {
                this.invoke((ClientRequest)new RollbackTransactionRequest());
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            this.state = Transaction.State.ROLLED_BACK;
        }
        finally {
            TRANSACTION_EXISTS.set(null);
        }
    }

    private void checkThread() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Transaction cannot span multiple threads!");
        }
    }

    private void checkTimeout() {
        if (this.startTime + this.options.getTimeoutMillis() < Clock.currentTimeMillis()) {
            throw new TransactionException("Transaction is timed-out!");
        }
    }

    private <T> T invoke(ClientRequest request) {
        if (request instanceof BaseTransactionRequest) {
            ((BaseTransactionRequest)request).setTxnId(this.txnId);
            ((BaseTransactionRequest)request).setClientThreadId(this.threadId);
        }
        SerializationService ss = this.client.getSerializationService();
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.client, request, this.connection);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (T)ss.toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

