/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.proxy.AbstractClientCollectionProxy;
import com.hazelcast.collection.impl.list.client.ListAddAllRequest;
import com.hazelcast.collection.impl.list.client.ListAddRequest;
import com.hazelcast.collection.impl.list.client.ListGetRequest;
import com.hazelcast.collection.impl.list.client.ListIndexOfRequest;
import com.hazelcast.collection.impl.list.client.ListRemoveRequest;
import com.hazelcast.collection.impl.list.client.ListSetRequest;
import com.hazelcast.collection.impl.list.client.ListSubRequest;
import com.hazelcast.core.IList;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.SerializableList;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class ClientListProxy<E>
extends AbstractClientCollectionProxy<E>
implements IList<E> {
    public ClientListProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ListAddAllRequest request = new ListAddAllRequest(this.getName(), valueList, index);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public E get(int index) {
        ListGetRequest request = new ListGetRequest(this.getName(), index);
        return (E)this.invoke((ClientRequest)request);
    }

    public E set(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ListSetRequest request = new ListSetRequest(this.getName(), index, value);
        return (E)this.invoke((ClientRequest)request);
    }

    public void add(int index, E element) {
        this.throwExceptionIfNull(element);
        Data value = this.toData(element);
        ListAddRequest request = new ListAddRequest(this.getName(), value, index);
        this.invoke((ClientRequest)request);
    }

    public E remove(int index) {
        ListRemoveRequest request = new ListRemoveRequest(this.getName(), index);
        return (E)this.invoke((ClientRequest)request);
    }

    public int indexOf(Object o) {
        return this.indexOfInternal(o, false);
    }

    public int lastIndexOf(Object o) {
        return this.indexOfInternal(o, true);
    }

    private int indexOfInternal(Object o, boolean last) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ListIndexOfRequest request = new ListIndexOfRequest(this.getName(), value, last);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    public ListIterator<E> listIterator(int index) {
        return this.subList(-1, -1).listIterator(index);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        ListSubRequest request = new ListSubRequest(this.getName(), fromIndex, toIndex);
        SerializableList result = (SerializableList)this.invoke((ClientRequest)request);
        List collection = result.getCollection();
        return new UnmodifiableLazyList(collection, this.getContext().getSerializationService());
    }

    public String toString() {
        return "IList{name='" + this.getName() + '\'' + '}';
    }
}

