/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.collection.client.CollectionAddAllRequest;
import com.hazelcast.collection.impl.collection.client.CollectionAddListenerRequest;
import com.hazelcast.collection.impl.collection.client.CollectionAddRequest;
import com.hazelcast.collection.impl.collection.client.CollectionClearRequest;
import com.hazelcast.collection.impl.collection.client.CollectionCompareAndRemoveRequest;
import com.hazelcast.collection.impl.collection.client.CollectionContainsRequest;
import com.hazelcast.collection.impl.collection.client.CollectionGetAllRequest;
import com.hazelcast.collection.impl.collection.client.CollectionIsEmptyRequest;
import com.hazelcast.collection.impl.collection.client.CollectionRemoveListenerRequest;
import com.hazelcast.collection.impl.collection.client.CollectionRemoveRequest;
import com.hazelcast.collection.impl.collection.client.CollectionRequest;
import com.hazelcast.collection.impl.collection.client.CollectionSizeRequest;
import com.hazelcast.core.ICollection;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableItemEvent;
import com.hazelcast.spi.impl.SerializableList;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AbstractClientCollectionProxy<E>
extends ClientProxy
implements ICollection<E> {
    protected final String partitionKey = this.getPartitionKey();

    public AbstractClientCollectionProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    public int size() {
        CollectionSizeRequest request = new CollectionSizeRequest(this.getName());
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean isEmpty() {
        CollectionIsEmptyRequest request = new CollectionIsEmptyRequest(this.getName());
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean contains(Object o) {
        this.throwExceptionIfNull(o);
        CollectionContainsRequest request = new CollectionContainsRequest(this.getName(), this.toData(o));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    public Object[] toArray() {
        return this.getAll().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        CollectionAddRequest request = new CollectionAddRequest(this.getName(), this.toData(e));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean remove(Object o) {
        this.throwExceptionIfNull(o);
        CollectionRemoveRequest request = new CollectionRemoveRequest(this.getName(), this.toData(o));
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean containsAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        CollectionContainsRequest request = new CollectionContainsRequest(this.getName(), valueSet);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean addAll(Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        CollectionAddAllRequest request = new CollectionAddAllRequest(this.getName(), valueList);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean removeAll(Collection<?> c) {
        return this.compareAndRemove(false, c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.compareAndRemove(true, c);
    }

    private boolean compareAndRemove(boolean retain, Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        CollectionCompareAndRemoveRequest request = new CollectionCompareAndRemoveRequest(this.getName(), valueSet, retain);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public void clear() {
        CollectionClearRequest request = new CollectionClearRequest(this.getName());
        this.invoke((ClientRequest)request);
    }

    public String addItemListener(final ItemListener<E> listener, boolean includeValue) {
        CollectionAddListenerRequest addRequest = new CollectionAddListenerRequest(this.getName(), includeValue);
        addRequest.setServiceName(this.getServiceName());
        EventHandler<PortableItemEvent> eventHandler = new EventHandler<PortableItemEvent>(){

            @Override
            public void handle(PortableItemEvent portableItemEvent) {
                Data item = portableItemEvent.getItem();
                Member member = AbstractClientCollectionProxy.this.getContext().getClusterService().getMember(portableItemEvent.getUuid());
                ItemEventType eventType = portableItemEvent.getEventType();
                SerializationService serializationService = AbstractClientCollectionProxy.this.getContext().getSerializationService();
                DataAwareItemEvent itemEvent = new DataAwareItemEvent(AbstractClientCollectionProxy.this.getName(), eventType, item, member, serializationService);
                if (eventType == ItemEventType.ADDED) {
                    listener.itemAdded((ItemEvent)itemEvent);
                } else {
                    listener.itemRemoved((ItemEvent)itemEvent);
                }
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        CollectionRemoveListenerRequest removeRequest = new CollectionRemoveListenerRequest(this.getName(), this.getServiceName());
        return this.registerListener((BaseClientAddListenerRequest)addRequest, (BaseClientRemoveListenerRequest)removeRequest, eventHandler);
    }

    public boolean removeItemListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        if (req instanceof CollectionRequest) {
            CollectionRequest request = (CollectionRequest)req;
            request.setServiceName(this.getServiceName());
        }
        return super.invoke(req, this.getPartitionKey());
    }

    private Collection<E> getAll() {
        CollectionGetAllRequest request = new CollectionGetAllRequest(this.getName());
        SerializableList result = (SerializableList)this.invoke((ClientRequest)request);
        List collection = result.getCollection();
        SerializationService serializationService = this.getContext().getSerializationService();
        return new UnmodifiableLazyList(collection, serializationService);
    }
}

