/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.buildutils;

import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.asm.ModifierAdjustment;
import net.bytebuddy.description.modifier.MethodManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class FinalRemovalAgent {
    private static final Map<String, Set<String>> FINAL_METHODS;

    private FinalRemovalAgent() {
    }

    public static void premain(String argument, Instrumentation instrumentation) {
        new AgentBuilder.Default().with((AgentBuilder.TypeStrategy)AgentBuilder.TypeStrategy.Default.REDEFINE).with((AgentBuilder.InitializationStrategy)AgentBuilder.InitializationStrategy.NoOp.INSTANCE).type((ElementMatcher)ElementMatchers.nameStartsWith((String)"com.hazelcast")).transform((builder, typeDescription, classLoader, module, domain) -> {
            int nonFinalModifiers;
            builder = FinalRemovalAgent.manifestMethodAsPlain(builder, typeDescription);
            int actualModifiers = typeDescription.getActualModifiers(false);
            if (actualModifiers != (nonFinalModifiers = actualModifiers & 0xFFFFFFEF)) {
                return builder.modifiers(nonFinalModifiers);
            }
            return builder;
        }).installOn(instrumentation);
    }

    private static DynamicType.Builder manifestMethodAsPlain(DynamicType.Builder builder, TypeDescription typeDescription) {
        String typeName = typeDescription.getName();
        if (FINAL_METHODS.containsKey(typeName)) {
            for (String methodName : FINAL_METHODS.get(typeName)) {
                builder = builder.visit((AsmVisitorWrapper)new ModifierAdjustment().withMethodModifiers((ElementMatcher)ElementMatchers.named((String)methodName), new ModifierContributor.ForMethod[]{MethodManifestation.PLAIN}));
            }
        }
        return builder;
    }

    static {
        HashMap<String, Set<String>> finalMethods = new HashMap<String, Set<String>>();
        finalMethods.put("com.hazelcast.cp.internal.session.AbstractProxySessionManager", Set.of("getSession", "getSessionAcquireCount"));
        finalMethods.put("com.hazelcast.spi.impl.AbstractInvocationFuture", Set.of("get", "join"));
        finalMethods.put("com.hazelcast.cp.internal.datastructures.spi.blocking.AbstractBlockingService", Set.of("getRegistryOrNull"));
        finalMethods.put("com.hazelcast.cp.internal.datastructures.spi.blocking.ResourceRegistry", Set.of("getWaitTimeouts"));
        FINAL_METHODS = finalMethods;
    }
}

