/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.buildutils;

import java.util.ArrayList;
import java.util.List;

public final class ElementParser {
    private static final int CHAR = 1;
    private static final int DELIMITER = 2;
    private static final int START_QUOTE = 4;
    private static final int END_QUOTE = 8;

    private ElementParser() {
    }

    public static List<String> parseDelimitedString(String value, char delimiter) {
        return ElementParser.parseDelimitedString(value, delimiter, true);
    }

    public static List<String> parseDelimitedString(String value, char delimiter, boolean trim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int expecting = 7;
        for (int i = 0; i < value.length(); ++i) {
            char character = value.charAt(i);
            boolean isEscaped = ElementParser.isEscaped(value, i);
            boolean isDelimiter = ElementParser.isDelimiter(delimiter, character, isEscaped);
            boolean isQuote = ElementParser.isQuote(character, isEscaped);
            if (isDelimiter && (expecting & 2) > 0) {
                ElementParser.addPart(list, sb, trim);
                sb.delete(0, sb.length());
                expecting = 7;
                continue;
            }
            if (isQuote && (expecting & 4) > 0) {
                sb.append(character);
                expecting = 9;
                continue;
            }
            if (isQuote && (expecting & 8) > 0) {
                sb.append(character);
                expecting = 7;
                continue;
            }
            if ((expecting & 1) > 0) {
                sb.append(character);
                continue;
            }
            String message = String.format("Invalid delimited string [%s] for delimiter: %s", value, Character.valueOf(delimiter));
            throw new IllegalArgumentException(message);
        }
        if (sb.length() > 0) {
            ElementParser.addPart(list, sb, trim);
        }
        return list;
    }

    private static boolean isEscaped(String value, int index) {
        return index > 0 && value.charAt(index - 1) == '\\';
    }

    private static boolean isQuote(char character, boolean isEscaped) {
        return !isEscaped && (character == '\"' || character == '\'');
    }

    private static boolean isDelimiter(char delimiter, char character, boolean isEscaped) {
        return !isEscaped && character == delimiter;
    }

    private static void addPart(List<String> list, StringBuilder sb, boolean trim) {
        list.add(trim ? sb.toString().trim() : sb.toString());
    }
}

