/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.junit.Test;

public class MixTestAnnotationsCondition
extends ArchCondition<JavaClass> {
    private static final Set<String> JUNIT_PACKAGES = Stream.of(TestCase.class, Test.class, org.junit.jupiter.api.Test.class).map(Class::getPackage).map(Package::getName).collect(Collectors.toSet());

    public MixTestAnnotationsCondition() {
        super("Do not mix different JUnit version references in the same Class", new Object[0]);
    }

    public void check(JavaClass item, ConditionEvents events) {
        Set junitReferences = Stream.concat(MixTestAnnotationsCondition.getAnnotationsForClass(item), MixTestAnnotationsCondition.getMethodReferencesInClass(item)).map(JavaClass::getPackageName).distinct().filter(JUNIT_PACKAGES::contains).collect(Collectors.toSet());
        if (junitReferences.size() > 1) {
            String message = String.format("Class %s mixes different JUnit version references %s.", item.getName(), junitReferences);
            events.add(SimpleConditionEvent.violated((Object)item, (String)message));
        }
    }

    private static Stream<JavaClass> getAnnotationsForClass(JavaClass item) {
        Stream classAnnotations = item.getAnnotations().stream();
        Stream methodAnnotations = item.getMethods().stream().map(JavaMethod::getAnnotations).flatMap(Collection::stream);
        return Stream.concat(classAnnotations, methodAnnotations).map(JavaAnnotation::getRawType);
    }

    private static Stream<JavaClass> getMethodReferencesInClass(JavaClass item) {
        return item.getMethodCallsFromSelf().stream().map(JavaAccess::getTarget).map(AccessTarget::getOwner);
    }

    public static ArchCondition<JavaClass> notMixDifferentJUnitVersionsAnnotations() {
        return new MixTestAnnotationsCondition();
    }
}

