/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.base.Optional;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.lang.syntax.ArchRuleDefinition;
import com.tngtech.archunit.lang.syntax.elements.GivenClassesConjunction;
import java.io.Serializable;

public final class ArchUnitRules {
    public static final ArchRule SERIALIZABLE_SHOULD_HAVE_VALID_SERIAL_VERSION_UID = ((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)((GivenClassesConjunction)ArchRuleDefinition.classes().that().areNotEnums()).and().doNotHaveModifier(JavaModifier.ABSTRACT)).and().implement(Serializable.class)).and().doNotImplement("com.hazelcast.nio.serialization.DataSerializable")).and().areNotAnonymousClasses()).should((ArchCondition)SerialVersionUidFieldCondition.haveValidSerialVersionUid());

    private ArchUnitRules() {
    }

    static class SerialVersionUidFieldCondition
    extends ArchCondition<JavaClass> {
        private static final String FIELD_NAME = "serialVersionUID";

        SerialVersionUidFieldCondition() {
            super("have a valid serialVersionUID", new Object[0]);
        }

        public void check(JavaClass clazz, ConditionEvents events) {
            Optional field = clazz.tryGetField(FIELD_NAME);
            if (field.isPresent()) {
                ArchConditions.haveRawType((String)"long").and(ArchConditions.beFinal()).and(ArchConditions.beStatic()).check(field.get(), events);
            } else {
                events.add(SimpleConditionEvent.violated((Object)clazz, (String)("serialVersionUID field is missing in class " + clazz.getName())));
            }
        }

        static SerialVersionUidFieldCondition haveValidSerialVersionUid() {
            return new SerialVersionUidFieldCondition();
        }
    }
}

