/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public final class RuntimeMetricSet {
    private RuntimeMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        metricsRegistry.registerStaticProbe(runtime, "runtime.freeMemory", ProbeLevel.MANDATORY, Runtime::freeMemory);
        metricsRegistry.registerStaticProbe(runtime, "runtime.totalMemory", ProbeLevel.MANDATORY, Runtime::totalMemory);
        metricsRegistry.registerStaticProbe(runtime, "runtime.maxMemory", ProbeLevel.MANDATORY, Runtime::maxMemory);
        metricsRegistry.registerStaticProbe(runtime, "runtime.usedMemory", ProbeLevel.MANDATORY, JVMUtil::usedMemory);
        metricsRegistry.registerStaticProbe(runtime, "runtime.availableProcessors", ProbeLevel.MANDATORY, Runtime::availableProcessors);
        metricsRegistry.registerStaticProbe(mxBean, "runtime.uptime", ProbeLevel.MANDATORY, RuntimeMXBean::getUptime);
    }
}

