/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Sets;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexBiVisitor;
import com.hazelcast.org.apache.calcite.rex.RexDigestIncludeType;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.Litmus;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class RexCall
extends RexNode {
    private static final Comparator<String> OPERAND_READABILITY_COMPARATOR = Comparator.comparing(String::length).thenComparing(Comparator.naturalOrder());
    public final SqlOperator op;
    public final ImmutableList<RexNode> operands;
    public final RelDataType type;
    public final int nodeCount;
    private static final Set<SqlKind> SIMPLE_BINARY_OPS;

    protected RexCall(RelDataType type, SqlOperator op, List<? extends RexNode> operands) {
        this.type = Objects.requireNonNull(type, "type");
        this.op = Objects.requireNonNull(op, "operator");
        this.operands = ImmutableList.copyOf(operands);
        this.nodeCount = RexUtil.nodeCount(1, this.operands);
        assert (op.getKind() != null) : op;
        assert (op.validRexOperands(operands.size(), Litmus.THROW)) : this;
    }

    protected final StringBuilder appendOperands(StringBuilder sb) {
        if (this.operands.isEmpty()) {
            return sb;
        }
        ArrayList<String> operandDigests = new ArrayList<String>(this.operands.size());
        for (int i = 0; i < this.operands.size(); ++i) {
            RexNode otherArg;
            RexNode operand = (RexNode)this.operands.get(i);
            if (!(operand instanceof RexLiteral)) {
                operandDigests.add(operand.toString());
                continue;
            }
            RexDigestIncludeType includeType = RexDigestIncludeType.OPTIONAL;
            if ((this.isA(SqlKind.AND) || this.isA(SqlKind.OR)) && operand.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            if (SIMPLE_BINARY_OPS.contains((Object)this.getKind()) && this.operands.size() == 2 && (!((otherArg = (RexNode)this.operands.get(1 - i)) instanceof RexLiteral) || ((RexLiteral)otherArg).digestIncludesType() == RexDigestIncludeType.NO_TYPE) && RexCall.equalSansNullability(operand.getType(), otherArg.getType())) {
                includeType = RexDigestIncludeType.NO_TYPE;
            }
            operandDigests.add(((RexLiteral)operand).computeDigest(includeType));
        }
        int totalLength = (operandDigests.size() - 1) * 2;
        for (String s : operandDigests) {
            totalLength += s.length();
        }
        sb.ensureCapacity(sb.length() + totalLength);
        this.sortOperandsIfNeeded(sb, this.operands, operandDigests);
        for (int i = 0; i < operandDigests.size(); ++i) {
            String op = (String)operandDigests.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(op);
        }
        return sb;
    }

    private void sortOperandsIfNeeded(StringBuilder sb, List<RexNode> operands, List<String> operandDigests) {
        if (operands.isEmpty() || !RexCall.needNormalize()) {
            return;
        }
        SqlKind kind = this.op.getKind();
        if (SqlKind.SYMMETRICAL_SAME_ARG_TYPE.contains((Object)kind)) {
            RelDataType firstType = operands.get(0).getType();
            for (int i = 1; i < operands.size(); ++i) {
                if (RexCall.equalSansNullability(firstType, operands.get(i).getType())) continue;
                return;
            }
        } else if (!(SqlKind.SYMMETRICAL.contains((Object)kind) || kind != kind.reverse() && this.op.getName().equals(kind.sql) && sb.length() >= kind.sql.length() + 1 && sb.charAt(sb.length() - 1) == '(')) {
            return;
        }
        String oldFirstArg = operandDigests.get(0);
        operandDigests.sort(OPERAND_READABILITY_COMPARATOR);
        if (kind != kind.reverse()) {
            assert (operands.size() == 2) : "Compare operation must have 2 arguments: " + this + ". Actual arguments are " + operandDigests;
            int operatorEnd = sb.length() - 1;
            int operatorStart = operatorEnd - this.op.getName().length();
            assert (this.op.getName().contentEquals(sb.subSequence(operatorStart, operatorEnd))) : "Operation name must precede opening brace like in <=(x, y). Actual content is " + sb.subSequence(operatorStart, operatorEnd) + " at position " + operatorStart + " in " + sb;
            SqlKind newKind = kind.reverse();
            if (operandDigests.get(0).equals(operandDigests.get(1)) ? newKind.compareTo(kind) > 0 : oldFirstArg.equals(operandDigests.get(0))) {
                return;
            }
            sb.replace(operatorStart, operatorEnd, newKind.sql);
        }
    }

    private static boolean equalSansNullability(RelDataType a, RelDataType b) {
        String x = a.getFullTypeString();
        String y = b.getFullTypeString();
        if (x.length() < y.length()) {
            String c = x;
            x = y;
            y = c;
        }
        return (x.length() == y.length() || x.length() == y.length() + 9 && x.endsWith(" NOT NULL")) && x.startsWith(y);
    }

    @Nonnull
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        if (this.operands.size() != 0 || this.op.getSyntax() != SqlSyntax.FUNCTION_ID) {
            sb.append("(");
            this.appendOperands(sb);
            sb.append(")");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }

    @Override
    @Nonnull
    public final String toString() {
        if (!RexCall.needNormalize()) {
            return this.computeDigest(this.digestWithType());
        }
        String localDigest = this.digest;
        if (localDigest == null) {
            localDigest = this.computeDigest(this.digestWithType());
            this.digest = Objects.requireNonNull(localDigest);
        }
        return localDigest;
    }

    private boolean digestWithType() {
        return this.isA(SqlKind.CAST) || this.isA(SqlKind.NEW_SPECIFICATION);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitCall(this, arg);
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public boolean isAlwaysTrue() {
        switch (this.getKind()) {
            case IS_NOT_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysFalse() {
        switch (this.getKind()) {
            case IS_NULL: {
                return !((RexNode)this.operands.get(0)).getType().isNullable();
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case NOT: {
                return ((RexNode)this.operands.get(0)).isAlwaysTrue();
            }
            case IS_NOT_FALSE: 
            case IS_TRUE: 
            case CAST: {
                return ((RexNode)this.operands.get(0)).isAlwaysFalse();
            }
        }
        return false;
    }

    @Override
    public SqlKind getKind() {
        return this.op.kind;
    }

    public List<RexNode> getOperands() {
        return this.operands;
    }

    public SqlOperator getOperator() {
        return this.op;
    }

    @Override
    public int nodeCount() {
        return this.nodeCount;
    }

    public RexCall clone(RelDataType type, List<RexNode> operands) {
        return new RexCall(type, this.op, operands);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof RexCall && this.toString().equals(obj.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    static {
        EnumSet<SqlKind> kinds = EnumSet.of(SqlKind.PLUS, SqlKind.MINUS, SqlKind.TIMES, SqlKind.DIVIDE);
        kinds.addAll(SqlKind.COMPARISON);
        kinds.remove((Object)SqlKind.IN);
        SIMPLE_BINARY_OPS = Sets.immutableEnumSet(kinds);
    }
}

