/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableSortedAggregate;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalAggregate;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;

class EnumerableSortedAggregateRule
extends ConverterRule {
    EnumerableSortedAggregateRule() {
        super(LogicalAggregate.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableSortedAggregateRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalAggregate agg = (LogicalAggregate)rel;
        if (!Aggregate.isSimple(agg)) {
            return null;
        }
        RelTraitSet inputTraits = rel.getCluster().traitSet().replace(EnumerableConvention.INSTANCE).replace(RelCollations.of(ImmutableIntList.copyOf(agg.getGroupSet().asList())));
        RelTraitSet selfTraits = inputTraits.replace(RelCollations.of(ImmutableIntList.identity(agg.getGroupSet().cardinality())));
        return new EnumerableSortedAggregate(rel.getCluster(), selfTraits, EnumerableSortedAggregateRule.convert(agg.getInput(), inputTraits), agg.getGroupSet(), agg.getGroupSets(), agg.getAggCallList());
    }
}

